/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.LinePump;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public abstract class AbstractLineHandler
extends AbstractNioHandler {
    private final Charset charset;
    private final LinePump.Mode lineMode;
    private boolean done;
    private int maxLineLength;
    private LinePump pump;

    protected AbstractLineHandler(@Nullable Charset charset) {
        this(charset, null);
    }

    protected AbstractLineHandler(@Nullable Charset charset, @Nullable LinePump.Mode lineMode) {
        this(charset, lineMode, Integer.MAX_VALUE);
    }

    protected AbstractLineHandler(@Nullable Charset charset, @Nullable LinePump.Mode lineMode, int maxLineLength) {
        this.charset = charset;
        this.lineMode = lineMode == null ? LinePump.Mode.CRLF_OR_LF : lineMode;
        this.setMaxLineLength(maxLineLength);
    }

    @Override
    public void onPreStart(@Nonnull NioProcess process) {
        this.done = false;
        this.pump = null;
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        if (this.done || this.isCanceled()) {
            if (buffer.hasRemaining()) {
                buffer.position(buffer.position() + buffer.remaining());
            }
            return;
        }
        if (this.pump == null) {
            if (this.lineMode != LinePump.Mode.NULL && this.isBinary(buffer)) {
                buffer.position(buffer.position() + buffer.remaining());
                try {
                    this.onBinary();
                }
                finally {
                    this.cancel();
                }
                this.done = true;
                return;
            }
            this.pump = new LinePump(this.charset == null ? this.detectCharset(buffer) : this.charset, this.lineMode, this.getMaxLineLength());
        }
        this.done = this.pump.forEach(buffer, closed, this::onStdout);
        if (this.done && !closed) {
            this.cancel();
        }
        if (closed || this.done) {
            this.onStdoutClosed();
        }
    }

    protected int getMaxLineLength() {
        return this.maxLineLength;
    }

    protected boolean isBinary(@Nonnull ByteBuffer buffer) {
        return ContentDetectionUtils.isBinary((ByteBuffer)buffer);
    }

    protected void onBinary() {
    }

    protected abstract boolean onStdout(@Nonnull String var1, boolean var2);

    protected void setMaxLineLength(int maxLineLength) {
        int n = this.maxLineLength = maxLineLength < 1 ? Integer.MAX_VALUE : maxLineLength;
        if (this.pump != null) {
            this.pump.setMaxLineLength(maxLineLength);
        }
    }

    protected void onStdoutClosed() {
    }

    private Charset detectCharset(@Nonnull ByteBuffer buffer) {
        String detected = ContentDetectionUtils.detectEncoding((ByteBuffer)buffer);
        if (detected == null) {
            return StandardCharsets.UTF_8;
        }
        try {
            return Charset.forName(detected);
        }
        catch (UnsupportedCharsetException e) {
            return StandardCharsets.UTF_8;
        }
    }
}

