/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandAware;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingStdoutHandler<T>
extends AbstractNioHandler
implements NioStdoutHandler<T>,
CommandAware {
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private WritableByteChannel channel;
    private Command<?> command;
    private Logger log;

    public AbstractLoggingStdoutHandler() {
    }

    public AbstractLoggingStdoutHandler(@Nonnull Logger log) {
        this();
        this.log = Objects.requireNonNull(log, "log");
    }

    @Override
    public void onPreStart(@Nonnull NioProcess process) {
        this.channel = null;
        this.output.reset();
    }

    @Override
    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        if (this.channel == null) {
            this.channel = Channels.newChannel(this.output);
        }
        try {
            this.channel.write(buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (closed) {
            this.logOutput();
        }
    }

    public void setCommand(@Nonnull Command<?> command) {
        this.command = Objects.requireNonNull(command, "command");
        if (this.log == null) {
            this.log = LoggerFactory.getLogger((Class)command.getClass());
        }
    }

    private void logOutput() {
        if (this.output.size() == 0) {
            this.log.trace("{}: Completed with no output", this.command);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("{}: Completed with the following output:\n{}", this.command, (Object)new String(this.output.toByteArray(), StandardCharsets.UTF_8));
        }
    }
}

