/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStringHandler
extends AbstractNioHandler {
    private static final int ENCODING_BUFFER_SIZE = 32768;
    private final StringBuilder builder;
    private final CharBuffer chars;
    private final Charset charset;
    private CharsetDecoder decoder;

    protected AbstractStringHandler() {
        this(null);
    }

    protected AbstractStringHandler(@Nullable Charset charset) {
        this.charset = charset;
        this.builder = new StringBuilder();
        this.chars = CharBuffer.allocate(128);
    }

    @Nonnull
    public String getResult() {
        return StringUtils.chomp((String)this.builder.toString());
    }

    @Override
    public void onPreStart(@Nonnull NioProcess process) {
        this.builder.setLength(0);
        this.decoder = null;
    }

    protected void appendOutput(ByteBuffer buffer, boolean closed) {
        CoderResult result;
        if (this.decoder == null) {
            if (closed && !buffer.hasRemaining()) {
                return;
            }
            this.decoder = (this.charset == null ? this.detectCharset(buffer) : this.charset).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        do {
            result = this.decoder.decode(buffer, this.chars, closed);
            this.chars.flip();
            if (this.chars.hasRemaining()) {
                this.builder.append(this.chars.array(), this.chars.arrayOffset(), this.chars.remaining());
            }
            this.chars.clear();
        } while (result.isOverflow());
    }

    private static Charset toCharset(String encoding) {
        return encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
    }

    private Charset detectCharset(BufferedInputStream stream) throws IOException {
        return AbstractStringHandler.toCharset(ContentDetectionUtils.detectEncoding((InputStream)stream, (int)32768));
    }

    private Charset detectCharset(ByteBuffer buffer) {
        return AbstractStringHandler.toCharset(ContentDetectionUtils.detectEncoding((ByteBuffer)buffer));
    }
}

