/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class BufferStdinHandler
extends AbstractNioHandler
implements NioStdinHandler {
    private final ByteBuffer data;

    public BufferStdinHandler(@Nonnull String data) {
        this(data, StandardCharsets.UTF_8);
    }

    public BufferStdinHandler(@Nonnull String data, @Nonnull Charset charset) {
        this(Objects.requireNonNull(data, "data").getBytes(Objects.requireNonNull(charset, "charset")));
    }

    public BufferStdinHandler(@Nonnull byte[] data) {
        this.data = ByteBuffer.wrap(Objects.requireNonNull(data, "data"));
    }

    @Override
    public void onStart(@Nonnull NioProcess process) {
        super.onStart(process);
        if (this.data.hasRemaining()) {
            process.wantWrite();
        } else {
            process.closeStdin(false);
        }
    }

    @Override
    public boolean onStdinReady(@Nonnull ByteBuffer buffer) {
        int bufferRemaining = buffer.remaining();
        if (this.data.remaining() > bufferRemaining) {
            buffer.put(this.data.slice().limit(bufferRemaining));
            buffer.flip();
            this.data.position(this.data.position() + bufferRemaining);
            return true;
        }
        buffer.put(this.data);
        buffer.flip();
        this.closeStdin();
        return false;
    }
}

