/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.dmz.process.CommitSink;
import com.atlassian.bitbucket.scm.git.command.CommitReaderSettings;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import jakarta.annotation.Nonnull;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommitPump {
    private static final String BASE_FORMAT = "%H|%P|%aN|%aE|%at|%cN|%cE|%ct".replace("|", "%x02");
    private static final int EXPECTED_TOKENS = 8;
    private static final String MESSAGE_FORMAT = BASE_FORMAT + "%n{0}%n%x03END%x04";
    private static final String OBJECT_END = "\u0003END\u0004";
    private static final Pattern PARENT_SEPARATORS = Pattern.compile("\\s");
    private static final char SEPARATOR_CHAR = '\u0002';
    private static final String UNSPECIFIED_NAME = "Unspecified";
    private final CommitSink sink;
    private final CommitReaderSettings settings;
    private final int maxMessageLength;
    private SimpleCommit.Builder builder;
    private StringBuilder message;

    public CommitPump(@Nonnull CommitReaderSettings settings, @Nonnull CommitSink sink) {
        this.settings = settings;
        this.sink = sink;
        this.maxMessageLength = settings.isMessageLengthUnlimited() ? Integer.MAX_VALUE : settings.getMaxMessageLength();
    }

    @Nonnull
    public static String getFormat(@Nonnull CommitReaderSettings settings) {
        return settings.getMessageMode().getPlaceholder().map(placeholder -> MessageFormat.format(MESSAGE_FORMAT, placeholder)).orElse(BASE_FORMAT);
    }

    @Nonnull
    public String getFormat() {
        return CommitPump.getFormat(this.settings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStdout(@Nonnull String line) {
        if (this.builder == null && line.startsWith("commit")) {
            return;
        }
        if (this.builder == null && line.contains(String.valueOf('\u0002'))) {
            String[] pieces = StringUtils.splitPreserveAllTokens((String)line, (char)'\u0002');
            if (pieces.length != 8) throw new IllegalStateException("[" + line + "]: Found " + pieces.length + " tokens where 8 were expected");
            this.builder = new SimpleCommit.Builder(pieces[0]).author(CommitPump.parsePerson(pieces[2], pieces[3])).authorTimestamp(CommitPump.parseTimestamp(pieces[4])).committer(CommitPump.parsePerson(pieces[5], pieces[6])).committerTimestamp(CommitPump.parseTimestamp(pieces[7])).repository(this.settings.getRepository());
            String rawFullHashes = pieces[1];
            if (StringUtils.isNotBlank((CharSequence)rawFullHashes)) {
                for (String fullHash : PARENT_SEPARATORS.split(rawFullHashes)) {
                    this.builder.parent((MinimalCommit)new SimpleMinimalCommit.Builder(fullHash).build());
                }
            }
            if (this.maxMessageLength == 0) {
                this.build();
                return;
            } else {
                this.message = new StringBuilder();
                this.sink.onPartialMessage(this.maxMessageLength);
            }
            return;
        } else {
            if (this.message == null) throw new IllegalStateException("[" + line + "]: Unexpected output; expected a 'commit' object");
            this.readMessage(line);
        }
    }

    private static String chompAll(StringBuilder builder) {
        char last;
        int end;
        for (end = builder.length(); end > 0 && ((last = builder.charAt(end - 1)) == '\r' || last == '\n'); --end) {
        }
        builder.setLength(end);
        return builder.toString();
    }

    private static Person parsePerson(String name, String email) {
        if (StringUtils.isBlank((CharSequence)name)) {
            name = UNSPECIFIED_NAME;
            email = null;
        }
        return new SimplePerson(name, email);
    }

    private static Date parseTimestamp(String timestamp) {
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            timestamp = "0";
        }
        return new Date(TimeUnit.SECONDS.toMillis(Long.parseLong(timestamp)));
    }

    private void build() {
        this.sink.onCommit((Commit)this.builder.build());
        this.reset();
    }

    private void readMessage(@Nonnull String line) {
        if (line.equals(OBJECT_END)) {
            this.builder = this.builder.message(CommitPump.chompAll(this.message));
            this.build();
            return;
        }
        if (this.maxMessageLength == Integer.MAX_VALUE) {
            this.message.append(line);
            this.message.append('\n');
        } else {
            int remaining = Math.max(this.maxMessageLength - this.message.length(), 0);
            if (remaining > 0) {
                this.message.append(line, 0, Math.min(line.length(), remaining));
                this.message.append('\n');
                this.sink.onPartialMessage(Math.max(remaining - line.length(), OBJECT_END.length()));
            }
        }
    }

    private void reset() {
        this.builder = null;
        this.message = null;
        this.sink.onPartialMessage(Integer.MAX_VALUE);
    }
}

