/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.AbstractNioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioHandlerSupport;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStderrHandler;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandAware;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiConsumer;

public class CompositeNioStdioHandler<T>
extends AbstractNioStdioHandler<T>
implements CommandAware,
CommandSummaryHandler {
    private final NioStderrHandler stderrHandler;
    private final NioStdinHandler stdinHandler;
    private final NioStdoutHandler<T> stdoutHandler;

    public CompositeNioStdioHandler(@Nonnull NioStdoutHandler<T> stdoutHandler) {
        this(stdoutHandler, null, null);
    }

    public CompositeNioStdioHandler(@Nonnull NioStdoutHandler<T> stdoutHandler, @Nonnull NioStdinHandler stdinHandler) {
        this(stdoutHandler, Objects.requireNonNull(stdinHandler, "stdinHandler"), null);
    }

    public CompositeNioStdioHandler(@Nonnull NioStdoutHandler<T> stdoutHandler, @Nullable NioStdinHandler stdinHandler, @Nullable NioStderrHandler stderrHandler) {
        this.stderrHandler = stderrHandler;
        this.stdinHandler = stdinHandler;
        this.stdoutHandler = Objects.requireNonNull(stdoutHandler, "stdoutHandler");
    }

    @Override
    public T getOutput() {
        return this.stdoutHandler.getOutput();
    }

    public void onComplete(@Nonnull CommandSummary summary) throws IOException {
        Throwable thrown = null;
        if (this.stdoutHandler instanceof CommandSummaryHandler) {
            try {
                ((CommandSummaryHandler)this.stdoutHandler).onComplete(summary);
            }
            catch (IOException | Error | RuntimeException e) {
                thrown = e;
            }
        }
        if (this.stdinHandler instanceof CommandSummaryHandler) {
            try {
                ((CommandSummaryHandler)this.stdinHandler).onComplete(summary);
            }
            catch (IOException | Error | RuntimeException e) {
                if (thrown == null) {
                    thrown = e;
                }
                thrown.addSuppressed(e);
            }
        }
        if (this.stderrHandler instanceof CommandSummaryHandler) {
            try {
                ((CommandSummaryHandler)this.stderrHandler).onComplete(summary);
            }
            catch (IOException | Error | RuntimeException e) {
                if (thrown == null) {
                    thrown = e;
                }
                thrown.addSuppressed(e);
            }
        }
        Throwables.propagateIfPossible((Throwable)thrown, IOException.class);
    }

    @Override
    public void onExit(int exitCode) {
        this.invokeHandlers(NioHandlerSupport::onExit, exitCode);
    }

    @Override
    public void onPreStart(@Nonnull NioProcess process) {
        this.invokeHandlers(NioHandlerSupport::onPreStart, process);
    }

    @Override
    public void onStart(@Nonnull NioProcess process) {
        this.invokeHandlers(NioHandlerSupport::onStart, process);
    }

    @Override
    public boolean onStdinReady(@Nonnull ByteBuffer buffer) {
        if (this.stdinHandler == null) {
            return super.onStdinReady(buffer);
        }
        return this.stdinHandler.onStdinReady(buffer);
    }

    @Override
    public void onStderr(@Nonnull ByteBuffer buffer, boolean closed) {
        if (this.stderrHandler == null) {
            super.onStderr(buffer, closed);
        } else {
            this.stderrHandler.onStderr(buffer, closed);
        }
    }

    @Override
    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        this.stdoutHandler.onStdout(buffer, closed);
    }

    public void setCommand(@Nonnull Command<?> command) {
        if (this.stdinHandler instanceof CommandAware) {
            ((CommandAware)this.stdinHandler).setCommand(command);
        }
        if (this.stdoutHandler instanceof CommandAware) {
            ((CommandAware)this.stdoutHandler).setCommand(command);
        }
        if (this.stderrHandler instanceof CommandAware) {
            ((CommandAware)this.stderrHandler).setCommand(command);
        }
    }

    private <P> void invokeHandlers(BiConsumer<NioHandlerSupport, P> callback, P value) {
        Throwable thrown = null;
        try {
            callback.accept(this.stdoutHandler, value);
        }
        catch (Error | RuntimeException e) {
            thrown = e;
        }
        if (this.stdinHandler != null) {
            try {
                callback.accept(this.stdinHandler, value);
            }
            catch (Error | RuntimeException e) {
                if (thrown == null) {
                    thrown = e;
                }
                thrown.addSuppressed(e);
            }
        }
        if (this.stderrHandler != null) {
            try {
                callback.accept(this.stderrHandler, value);
            }
            catch (Error | RuntimeException e) {
                if (thrown == null) {
                    thrown = e;
                }
                thrown.addSuppressed(e);
            }
        }
        if (thrown != null) {
            Throwables.throwIfUnchecked((Throwable)thrown);
        }
    }
}

