/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.LineSink;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LinePump {
    private static final char NULL_CHAR = '\u0000';
    private final ReadAheadCharSource charSource;
    private final CharsetDecoder decoder;
    private final Mode mode;
    private StringBuilder builder;
    private int cutoffLength;
    private int maxLineLength;

    public LinePump(@Nonnull Charset charset) {
        this(charset, Mode.CRLF_OR_LF);
    }

    public LinePump(@Nonnull Charset charset, @Nonnull Mode mode) {
        this(charset, mode, Integer.MAX_VALUE);
    }

    public LinePump(@Nonnull Charset charset, @Nonnull Mode mode, int maxLineLength) {
        this.mode = Objects.requireNonNull(mode, "mode");
        this.builder = new StringBuilder();
        this.decoder = Objects.requireNonNull(charset, "charset").newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.charSource = new ReadAheadCharSource();
        this.setMaxLineLength(maxLineLength);
    }

    public boolean forEach(@Nonnull ByteBuffer bytes, boolean closed, @Nonnull LineSink sink) {
        CoderResult result;
        Objects.requireNonNull(sink, "sink");
        CharBuffer chars = CharBuffer.allocate(Math.min(5000, Objects.requireNonNull(bytes, "bytes").remaining()));
        do {
            int c;
            result = this.decoder.decode(bytes, chars, closed);
            chars.flip();
            this.charSource.fill(chars);
            while ((c = this.charSource.readNext()) != -1) {
                boolean isEol = false;
                if (this.mode == Mode.LF) {
                    isEol = c == 10;
                } else if (this.mode == Mode.NULL) {
                    isEol = c == 0;
                } else if (c == 10) {
                    isEol = true;
                } else if (c == 13) {
                    int c2 = this.charSource.readNext();
                    if (c2 == -1) {
                        this.charSource.pushBack(c);
                        break;
                    }
                    if (c2 == 10) {
                        isEol = true;
                    } else if (this.mode == Mode.CRLF_CR_OR_LF) {
                        isEol = true;
                        this.charSource.pushBack(c2);
                    } else {
                        this.charSource.pushBack(c2);
                    }
                }
                if (isEol) {
                    if (this.offerLine(sink, this.builder)) {
                        this.builder = new StringBuilder();
                        continue;
                    }
                    return true;
                }
                if (this.builder.length() >= this.cutoffLength) continue;
                this.builder.append((char)c);
            }
            chars.clear();
        } while (result.isOverflow());
        if (closed && this.builder.length() != 0) {
            this.offerLine(sink, this.builder);
        }
        return closed;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength < 1 ? Integer.MAX_VALUE : maxLineLength;
        this.cutoffLength = this.maxLineLength > 0x7FFFFFFD ? Integer.MAX_VALUE : this.maxLineLength + 2;
    }

    private boolean offerLine(LineSink sink, StringBuilder line) {
        boolean truncated = line.length() > this.maxLineLength;
        return sink.accept(truncated ? line.substring(0, this.maxLineLength) : line.toString(), truncated);
    }

    public static enum Mode {
        CRLF_OR_LF,
        CRLF_CR_OR_LF,
        LF,
        NULL;

    }

    private static class ReadAheadCharSource {
        CharBuffer currentBuffer;
        int readAhead = -1;

        void fill(CharBuffer buffer) {
            this.currentBuffer = buffer;
        }

        void pushBack(int readAhead) {
            Preconditions.checkState((this.readAhead == -1 ? 1 : 0) != 0, (Object)"read ahead buffer is not empty");
            this.readAhead = readAhead;
        }

        int readNext() {
            if (this.readAhead != -1) {
                int readAhead = this.readAhead;
                this.readAhead = -1;
                return readAhead;
            }
            if (!this.currentBuffer.hasRemaining()) {
                return -1;
            }
            return this.currentBuffer.get();
        }
    }
}

