/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;

public class LineStdinHandler
extends AbstractNioHandler
implements NioStdinHandler {
    private final Charset charset;
    private final Iterable<String> lines;
    private CharsetEncoder encoder;
    private Iterator<String> iterator;
    private CharBuffer next;

    public LineStdinHandler(@Nonnull Iterable<String> lines) {
        this(lines, StandardCharsets.UTF_8);
    }

    public LineStdinHandler(@Nonnull Iterable<String> lines, @Nonnull Charset charset) {
        this.charset = Objects.requireNonNull(charset, "charset");
        this.lines = Objects.requireNonNull(lines, "lines");
    }

    @Override
    public void onStart(@Nonnull NioProcess process) {
        super.onStart(process);
        this.encoder = this.charset.newEncoder();
        this.iterator = this.lines.iterator();
        if (this.iterator.hasNext()) {
            process.wantWrite();
        } else {
            process.closeStdin(false);
        }
    }

    @Override
    public boolean onStdinReady(@Nonnull ByteBuffer buffer) {
        if (this.next != null) {
            if (this.encoder.encode(this.next, buffer, !this.iterator.hasNext()).isOverflow()) {
                buffer.flip();
                return true;
            }
            this.next = null;
        }
        while (this.iterator.hasNext()) {
            CharBuffer line = CharBuffer.wrap(this.iterator.next() + "\n");
            if (!this.encoder.encode(line, buffer, !this.iterator.hasNext()).isOverflow()) continue;
            buffer.flip();
            this.next = line;
            return true;
        }
        buffer.flip();
        this.closeStdin();
        return false;
    }
}

