/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

public class PathStdinHandler
extends AbstractNioHandler
implements NioStdinHandler {
    private final Path path;
    private ReadableByteChannel channel;

    public PathStdinHandler(@Nonnull Path path) {
        this.path = Objects.requireNonNull(path, "path");
    }

    @Override
    public void onExit(int exitCode) {
        ReadableByteChannel channel = this.channel;
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close input channel", e);
            }
            this.channel = null;
        }
    }

    @Override
    public void onStart(@Nonnull NioProcess process) {
        super.onStart(process);
        process.wantWrite();
    }

    @Override
    public boolean onStdinReady(@Nonnull ByteBuffer buffer) {
        try {
            if (this.channel == null) {
                this.channel = Files.newByteChannel(this.path, StandardOpenOption.READ);
            }
            int read = this.channel.read(buffer);
            buffer.flip();
            if (read == -1) {
                this.channel.close();
                this.channel = null;
                this.closeStdin();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy from input channel to stdin", e);
        }
    }

    @VisibleForTesting
    boolean isOpen() {
        ReadableByteChannel channel = this.channel;
        return channel != null && channel.isOpen();
    }
}

