/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.process;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class PathStdoutHandler
extends AbstractNioHandler
implements NioStdoutHandler<Long> {
    private final boolean append;
    private final Path path;
    private WritableByteChannel channel;
    private long written;

    public PathStdoutHandler(Path path) {
        this(path, false);
    }

    public PathStdoutHandler(Path path, boolean append) {
        this.append = append;
        this.path = path;
    }

    @Override
    public void onExit(int exitCode) {
        WritableByteChannel channel = this.channel;
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close output channel", e);
            }
            this.channel = null;
        }
    }

    @Override
    public Long getOutput() {
        return this.written;
    }

    @Override
    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        try {
            if (this.channel == null) {
                WritableByteChannel writableByteChannel = this.channel = this.append ? Files.newByteChannel(this.path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND) : Files.newByteChannel(this.path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            if (buffer.hasRemaining()) {
                this.written += (long)this.channel.write(buffer);
            }
            if (closed) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy from stdout to output channel", e);
        }
    }

    @VisibleForTesting
    boolean isOpen() {
        WritableByteChannel channel = this.channel;
        return channel != null && channel.isOpen();
    }
}

