/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.exception.PasswordEncoderException;
import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;

public class Argon2PasswordEncoder
implements InternalPasswordEncoder {
    private static final String PREFIX = "{ARGON2}";
    private static final int DEFAULT_SALT_LENGTH = 32;
    private static final int DEFAULT_HASH_LENGTH = 32;
    private static final int DEFAULT_PARALLELISM = 1;
    private static final int DEFAULT_MEMORY = 15360;
    private static final int DEFAULT_ITERATIONS = 2;
    private final org.springframework.security.crypto.argon2.Argon2PasswordEncoder argon2Encoder;

    public Argon2PasswordEncoder() {
        this(32, 32, 1, 15360, 2);
    }

    public Argon2PasswordEncoder(int saltLength, int hashLength, int parallelism, int memory, int iterations) {
        this.argon2Encoder = new org.springframework.security.crypto.argon2.Argon2PasswordEncoder(saltLength, hashLength, parallelism, memory, iterations);
    }

    public String encodePassword(String rawPass, Object salt) throws PasswordEncoderException {
        return this.prependPrefix(this.argon2Encoder.encode((CharSequence)rawPass));
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        return this.argon2Encoder.matches((CharSequence)rawPass, this.removePrefix(encPass));
    }

    public String getKey() {
        return "argon2";
    }

    private String prependPrefix(String encodedPassword) {
        return PREFIX + encodedPassword;
    }

    private String removePrefix(String encodedPassword) {
        return encodedPassword.substring(PREFIX.length());
    }
}

