/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.common.properties.SystemProperties;
import com.atlassian.crowd.exception.PasswordEncoderException;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.crowd.password.encoder.PKCS5S2SHA2PasswordHashGenerator;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.encoder.UpgradeablePasswordEncoder;
import com.atlassian.crowd.password.saltgenerator.SecureRandomSaltGenerator;
import com.atlassian.security.password.DefaultPasswordEncoder;
import com.atlassian.security.password.PKCS5S2PasswordHashGenerator;
import com.atlassian.security.password.PasswordHashGenerator;
import com.atlassian.security.password.SaltGenerator;
import java.util.List;

public class AtlassianSecurityPasswordEncoder
implements InternalPasswordEncoder,
UpgradeablePasswordEncoder {
    private static final com.atlassian.security.password.PasswordEncoder ADVANCED_PASSWORD_ENCODER = new DefaultPasswordEncoder("PKCS5S2_SHA2", (PasswordHashGenerator)new PKCS5S2SHA2PasswordHashGenerator(), (SaltGenerator)SecureRandomSaltGenerator.INSTANCE);
    private static final com.atlassian.security.password.PasswordEncoder STANDARD_PASSWORD_ENCODER = new DefaultPasswordEncoder("PKCS5S2", (PasswordHashGenerator)new PKCS5S2PasswordHashGenerator(), (SaltGenerator)SecureRandomSaltGenerator.INSTANCE);
    private final List<com.atlassian.security.password.PasswordEncoder> supportedPasswordEncoders;
    private final PasswordEncoder legacyPasswordEncoder;

    public AtlassianSecurityPasswordEncoder() {
        this(AtlassianSecurityPasswordEncoder.getSupportedEncoders(), (PasswordEncoder)new AtlassianSHA1PasswordEncoder());
    }

    AtlassianSecurityPasswordEncoder(com.atlassian.security.password.PasswordEncoder defaultPasswordEncoder, PasswordEncoder legacyPasswordEncoder) {
        this(List.of(defaultPasswordEncoder), legacyPasswordEncoder);
    }

    private AtlassianSecurityPasswordEncoder(List<com.atlassian.security.password.PasswordEncoder> supportedPasswordEncoders, PasswordEncoder legacyPasswordEncoder) {
        if (supportedPasswordEncoders.isEmpty()) {
            throw new IllegalArgumentException("Supported encoders list must contain at least 1 element");
        }
        this.supportedPasswordEncoders = supportedPasswordEncoders;
        this.legacyPasswordEncoder = legacyPasswordEncoder;
    }

    public String encodePassword(String rawPass, Object salt) throws PasswordEncoderException {
        try {
            return this.getDefaultPasswordEncoder().encodePassword(rawPass);
        }
        catch (IllegalArgumentException e) {
            throw new PasswordEncoderException("Password could not be encoded.", (Throwable)e);
        }
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        return this.supportedPasswordEncoders.stream().filter(encoder -> encoder.canDecodePassword(encPass)).findFirst().map(encoder -> this.isValidPassword((com.atlassian.security.password.PasswordEncoder)encoder, rawPass, encPass)).orElseGet(() -> this.legacyPasswordEncoder.isPasswordValid(encPass, rawPass, salt));
    }

    public boolean isUpgradeRequired(String encPass) {
        return !this.getDefaultPasswordEncoder().canDecodePassword(encPass);
    }

    public String getKey() {
        return "atlassian-security";
    }

    private com.atlassian.security.password.PasswordEncoder getDefaultPasswordEncoder() {
        return this.supportedPasswordEncoders.get(0);
    }

    private boolean isValidPassword(com.atlassian.security.password.PasswordEncoder passwordEncoder, String rawPass, String encPass) {
        try {
            return passwordEncoder.isValidPassword(rawPass, encPass);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static List<com.atlassian.security.password.PasswordEncoder> getSupportedEncoders() {
        return (Boolean)SystemProperties.ADVANCED_SECURITY_PASSWORD_ENCODER_ENABLED.getValue() != false ? List.of(ADVANCED_PASSWORD_ENCODER, STANDARD_PASSWORD_ENCODER) : List.of(STANDARD_PASSWORD_ENCODER, ADVANCED_PASSWORD_ENCODER);
    }
}

