/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.filters;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.filters.AbstractJohnsonFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class JohnsonFilter
extends AbstractJohnsonFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JohnsonFilter.class);

    @Override
    protected void handleError(JohnsonEventContainer appEventContainer, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String servletPath = JohnsonFilter.getServletPath(servletRequest);
        String contextPath = servletRequest.getContextPath();
        LOG.info("The application is still starting up, or there are errors. Redirecting request from '{}' to '{}'", (Object)servletPath, (Object)this.config.getErrorPath());
        Object nextUrl = servletRequest.getRequestURI();
        if (servletRequest.getQueryString() != null && !servletRequest.getQueryString().isEmpty()) {
            nextUrl = (String)nextUrl + "?" + servletRequest.getQueryString();
        }
        String redirectUrl = contextPath + this.config.getErrorPath() + "?next=" + URLEncoder.encode((String)nextUrl, "UTF-8");
        servletResponse.sendRedirect(redirectUrl);
    }

    @Override
    protected void handleNotSetup(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String servletPath = JohnsonFilter.getServletPath(servletRequest);
        String contextPath = servletRequest.getContextPath();
        LOG.info("The application is not yet setup. Redirecting request from '{}' to '{}'", (Object)servletPath, (Object)this.config.getSetupPath());
        servletResponse.sendRedirect(contextPath + this.config.getSetupPath());
    }
}

