/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2;

import com.atlassian.plugins.rest.v2.json.JacksonVersion;
import com.atlassian.plugins.rest.v2.version.ApiVersion;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RestApiContext {
    public static final String SLASH = "/";
    public static final String LATEST = "/latest";
    public static final String ANY_PATH_PATTERN = "/*";
    private final String restContext;
    private final String apiPath;
    private final ApiVersion version;
    private final Set<String> packages;
    private final boolean indexBundledJars;
    private final JacksonVersion jacksonVersion;

    public RestApiContext(String restContext, String apiContext, ApiVersion version, Set<String> packages, boolean indexBundledJars, JacksonVersion jacksonVersion) {
        this.restContext = this.prependSlash(Objects.requireNonNull(restContext, "restContext can't be null"));
        this.apiPath = this.prependSlash(Objects.requireNonNull(apiContext, "apiContext can't be null"));
        this.version = Objects.requireNonNull(version, "version can't be null");
        this.packages = Objects.requireNonNull(packages, "packages can't be null");
        this.indexBundledJars = indexBundledJars;
        this.jacksonVersion = jacksonVersion;
    }

    public String getRestContext() {
        return this.restContext;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public ApiVersion getVersion() {
        return this.version;
    }

    public String getPathToVersion() {
        return this.getPathToVersion(this.version);
    }

    public String getPathToLatest() {
        return this.getPathToVersion(LATEST);
    }

    public String getPathToVersion(String version) {
        return this.restContext + this.getContextlessPathToVersion(version);
    }

    private String getPathToVersion(ApiVersion version) {
        return this.restContext + this.getContextlessPathToVersion(version);
    }

    public String getContextlessPathToVersion() {
        return this.getContextlessPathToVersion(this.version);
    }

    private String getContextlessPathToVersion(String version) {
        return ApiVersion.isNone(version) ? this.apiPath : this.apiPath + this.prependSlash(version);
    }

    private String getContextlessPathToVersion(ApiVersion version) {
        return version.isNone() ? this.apiPath : this.apiPath + this.prependSlash(version.toString());
    }

    private String prependSlash(String path) {
        return StringUtils.startsWith((CharSequence)path, (CharSequence)SLASH) ? path : SLASH + path;
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public void disabled() {
    }

    public Boolean getIndexBundledJars() {
        return this.indexBundledJars;
    }

    public JacksonVersion getJacksonVersion() {
        return this.jacksonVersion;
    }
}

