/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.expand;

import com.atlassian.plugins.rest.api.expand.EntityCrawler;
import com.atlassian.plugins.rest.api.expand.annotation.Expandable;
import com.atlassian.plugins.rest.api.expand.expander.EntityExpander;
import com.atlassian.plugins.rest.api.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.api.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.v2.expand.DefaultExpandContext;
import com.atlassian.plugins.rest.v2.util.ReflectionUtils;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultEntityCrawler
implements EntityCrawler {
    private final ConcurrentMap<Class, List<Field>> declaredFields = new ConcurrentHashMap<Class, List<Field>>();
    private final ConcurrentMap<Class, Optional<Field>> expandFields = new ConcurrentHashMap<Class, Optional<Field>>();

    public void crawl(Object entity, ExpandParameter expandParameter, EntityExpanderResolver expanderResolver) {
        if (entity == null) {
            return;
        }
        Collection<Field> expandableFields = this.getExpandableFields(entity);
        this.setExpandParameter(expandableFields, entity);
        this.expandFields(expandableFields, entity, expandParameter, expanderResolver);
    }

    private void setExpandParameter(Collection<Field> expandableFields, Object entity) {
        Optional expand = this.expandFields.computeIfAbsent(entity.getClass(), this::getExpandFields);
        if (expand.isPresent() && !expandableFields.isEmpty()) {
            String expandValue = this.createExpandString(expandableFields);
            ReflectionUtils.setFieldValue((Field)expand.get(), entity, expandValue);
        }
    }

    private String createExpandString(Collection<Field> expandableFields) {
        return expandableFields.stream().map(this::getExpandable).map(Expandable::value).distinct().collect(Collectors.joining(","));
    }

    private Collection<Field> getExpandableFields(Object entity) {
        return this.declaredFields.computeIfAbsent(entity.getClass(), this::getDeclaredFields).stream().filter(field -> this.getExpandable((Field)field) != null && ReflectionUtils.getFieldValue(field, entity) != null).collect(Collectors.toCollection(LinkedList::new));
    }

    private void expandFields(Collection<Field> expandableFields, Object entity, ExpandParameter expandParameter, EntityExpanderResolver expanderResolver) {
        for (Field field : expandableFields) {
            Expandable expandable = this.getExpandable(field);
            if (!expandParameter.shouldExpand(expandable) || !expanderResolver.hasExpander(field.getType())) continue;
            EntityExpander entityExpander = expanderResolver.getExpander(field.getType());
            DefaultExpandContext<Object> context = new DefaultExpandContext<Object>(ReflectionUtils.getFieldValue(field, entity), expandable, expandParameter);
            ReflectionUtils.setFieldValue(field, entity, entityExpander.expand(context, expanderResolver, (EntityCrawler)this));
        }
    }

    Expandable getExpandable(Field field) {
        if (field == null) {
            return null;
        }
        Expandable expandable = field.getAnnotation(Expandable.class);
        if (expandable == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)expandable.value())) {
            return expandable;
        }
        XmlElement xmlElement = field.getAnnotation(XmlElement.class);
        if (xmlElement != null && StringUtils.isNotEmpty((CharSequence)xmlElement.name()) && !StringUtils.equals((CharSequence)"##default", (CharSequence)xmlElement.name())) {
            return new ExpandableWithValue(xmlElement.name());
        }
        return new ExpandableWithValue(field.getName());
    }

    private List<Field> getDeclaredFields(Class cls) {
        return new LinkedList<Field>(ReflectionUtils.getDeclaredFields(cls));
    }

    private Optional<Field> getExpandFields(Class cls) {
        for (Field field : this.declaredFields.computeIfAbsent(cls, this::getDeclaredFields)) {
            XmlAttribute annotation;
            if (!field.getType().equals(String.class) || (annotation = field.getAnnotation(XmlAttribute.class)) == null || !field.getName().equals("expand") && !"expand".equals(annotation.name())) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private static class ExpandableWithValue
    implements Expandable {
        private final String value;

        public ExpandableWithValue(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public Class<? extends Annotation> annotationType() {
            return Expandable.class;
        }
    }
}

