/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.multipart.jersey;

import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartForm;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

public class MultipartFormParamValueParamProvider
implements ValueParamProvider {
    public Function<ContainerRequest, ?> getValueProvider(Parameter parameter) {
        Class rawType = parameter.getRawType();
        String sourceName = parameter.getSourceName();
        if (parameter.isAnnotationPresent(MultipartFormParam.class)) {
            if (FilePart.class == rawType) {
                return new FilePartParamProvider(sourceName);
            }
            if (List.class == rawType) {
                return new FileListPartParamProvider(sourceName);
            }
            if (Set.class == rawType) {
                return new FileSetPartParamProvider(sourceName);
            }
            if (Collection.class == rawType) {
                return new FilesPartParamProvider(sourceName);
            }
        }
        return null;
    }

    public ValueParamProvider.PriorityType getPriority() {
        return ValueParamProvider.Priority.HIGH;
    }

    private static class FilePartParamProvider
    extends ValueProvider<FilePart> {
        private final String paramName;

        public FilePartParamProvider(String paramName) {
            this.paramName = paramName;
        }

        @Override
        public FilePart apply(ContainerRequest request) {
            return this.getEntity(request).getFilePart(this.paramName);
        }
    }

    private static class FileListPartParamProvider
    extends ValueProvider<List<FilePart>> {
        private final String paramName;

        public FileListPartParamProvider(String paramName) {
            this.paramName = paramName;
        }

        @Override
        public List<FilePart> apply(ContainerRequest request) {
            return new ArrayList<FilePart>(this.getEntity(request).getFileParts(this.paramName));
        }
    }

    private static class FileSetPartParamProvider
    extends ValueProvider<Set<FilePart>> {
        private final String paramName;

        public FileSetPartParamProvider(String paramName) {
            this.paramName = paramName;
        }

        @Override
        public Set<FilePart> apply(ContainerRequest request) {
            return new HashSet<FilePart>(this.getEntity(request).getFileParts(this.paramName));
        }
    }

    private static class FilesPartParamProvider
    extends ValueProvider<Collection<FilePart>> {
        private final String paramName;

        public FilesPartParamProvider(String paramName) {
            this.paramName = paramName;
        }

        @Override
        public Collection<FilePart> apply(ContainerRequest request) {
            return this.getEntity(request).getFileParts(this.paramName);
        }
    }

    private static abstract class ValueProvider<T>
    implements Function<ContainerRequest, T> {
        private ValueProvider() {
        }

        MultipartForm getEntity(ContainerRequest request) {
            String requestPropertyName = MultipartForm.class.getName();
            Object entity = request.getProperty(requestPropertyName);
            if (entity == null) {
                entity = request.readEntity(MultipartForm.class);
                if (entity == null) {
                    throw new BadRequestException("Entity is empty");
                }
                request.setProperty(requestPropertyName, entity);
            }
            return (MultipartForm)entity;
        }
    }
}

