/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.scanner;

import com.atlassian.plugins.rest.v2.scanner.AnnotatedScannerException;
import com.atlassian.plugins.rest.v2.scanner.JarIndexer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.osgi.framework.Bundle;

public final class AnnotatedClassScanner {
    private static final String REFERENCE_PROTOCOL = "reference:";
    private static final String FILE_PROTOCOL = "file:";
    private final Bundle bundle;
    private final Set<String> annotations;
    private boolean indexBundledJars;

    public AnnotatedClassScanner(Bundle bundle, boolean indexBundledJars, Class<?> ... annotations) {
        Validate.notNull((Object)bundle);
        Validate.notEmpty((Object[])annotations, (String)"You gotta scan for something!", (Object[])new Object[0]);
        this.indexBundledJars = indexBundledJars;
        this.bundle = bundle;
        this.annotations = this.getAnnotationSet(annotations);
    }

    public Set<Class<?>> scan(Collection<String> basePackages) {
        Set<Class<?>> set;
        File bundleFile = this.getBundleFile(this.bundle);
        if (!bundleFile.isFile() || !bundleFile.exists()) {
            throw new AnnotatedScannerException("Could not identify Bundle at location <" + this.bundle.getLocation() + ">");
        }
        JarFile jarFile = new JarFile(bundleFile);
        try {
            set = new JarIndexer(jarFile, this.preparePackages(basePackages), this.indexBundledJars, this.annotations, this.bundle).scanJar();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AnnotatedScannerException(e.getMessage());
            }
        }
        jarFile.close();
        return set;
    }

    File getBundleFile(Bundle bundle) {
        File bundleFile;
        String bundleLocation = bundle.getLocation();
        if (bundleLocation.startsWith(REFERENCE_PROTOCOL)) {
            bundleLocation = bundleLocation.substring(REFERENCE_PROTOCOL.length());
        }
        if (bundleLocation.startsWith(FILE_PROTOCOL)) {
            try {
                bundleFile = new File(URLDecoder.decode(new URL(bundleLocation).getFile(), "UTF-8"));
            }
            catch (MalformedURLException e) {
                throw new AnnotatedScannerException("Could not parse Bundle location as URL <" + bundleLocation + ">", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Obviously something is wrong with your JVM... It doesn't support UTF-8 !?!", e);
            }
        } else {
            bundleFile = new File(bundleLocation);
        }
        return bundleFile;
    }

    private Set<String> preparePackages(Collection<String> packages) {
        HashSet<String> packageNames = new HashSet<String>();
        for (String packageName : packages) {
            String newPackageName = StringUtils.replaceChars((String)packageName, (char)'.', (char)'/');
            if (!newPackageName.endsWith("/")) {
                packageNames.add(newPackageName + "/");
                continue;
            }
            packageNames.add(newPackageName);
        }
        return packageNames;
    }

    Set<String> getAnnotationSet(Class<?> ... annotations) {
        HashSet<String> formattedAnnotations = new HashSet<String>();
        for (Class<?> cls : annotations) {
            formattedAnnotations.add("L" + cls.getName().replace(".", "/") + ";");
        }
        return formattedAnnotations;
    }

    public void setIndexBundledJars(boolean indexBundledJars) {
        this.indexBundledJars = indexBundledJars;
    }
}

