/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.antisniffing;

import com.atlassian.sal.api.web.context.HttpContext;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Objects;

@Priority(value=3000)
@Provider
public class AntiSniffingResponseFilter
implements ContainerResponseFilter {
    private HttpContext httpContext;
    public static final String ANTI_SNIFFING_HEADER_NAME = "X-Content-Type-Options";
    public static final String ANTI_SNIFFING_HEADER_VALUE = "nosniff";

    public AntiSniffingResponseFilter(HttpContext httpContext) {
        this.httpContext = Objects.requireNonNull(httpContext, "httpContext can't be null");
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!this.httpContext.getResponse().containsHeader(ANTI_SNIFFING_HEADER_NAME) && !responseContext.getHeaders().containsKey((Object)ANTI_SNIFFING_HEADER_NAME)) {
            responseContext.getHeaders().add((Object)ANTI_SNIFFING_HEADER_NAME, (Object)ANTI_SNIFFING_HEADER_VALUE);
        }
    }
}

