/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.servlet;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugins.rest.v2.ChainingClassLoader;
import com.atlassian.plugins.rest.v2.RestApiContext;
import com.atlassian.plugins.rest.v2.Slf4jBridge;
import com.atlassian.plugins.rest.v2.descriptor.RestModuleDescriptor;
import com.atlassian.plugins.rest.v2.filter.ExtensionJerseyFilter;
import com.atlassian.plugins.rest.v2.jersey.JerseyOsgiServletContainer;
import com.atlassian.plugins.rest.v2.jersey.ResourceConfigFactory;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDelegatingServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RestDelegatingServletFilter.class);
    private static final Slf4jBridge.Helper SLF4J_BRIDGE = Slf4jBridge.createHelper();
    private static final String PARAM_EXTENSION_FILTER_EXCLUDES = "extension.filter.excludes";
    private final Filter servletContainer;
    private final ResourceConfig resourceConfig;
    private ClassLoader chainingClassLoader;

    public RestDelegatingServletFilter(OsgiPlugin plugin, RestApiContext restContextPath, ResourceConfigFactory resourceConfigFactory) {
        this.resourceConfig = resourceConfigFactory.createConfig(plugin, restContextPath.getPackages(), restContextPath.getIndexBundledJars(), restContextPath.getJacksonVersion());
        this.servletContainer = new JerseyOsgiServletContainer(plugin, restContextPath, this.resourceConfig);
    }

    public void init(FilterConfig config) throws ServletException {
        this.initChainingClassLoader();
        this.initServletContainer(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.chainingClassLoader);
        try {
            this.servletContainer.doFilter(request, response, chain);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    public void destroy() {
        this.destroyServletContainer();
    }

    public void registerSingletonsFromInitParams(Map<String, String> initParams) {
        if (initParams.containsKey(PARAM_EXTENSION_FILTER_EXCLUDES)) {
            String[] excludes = StringUtils.split((String)initParams.get(PARAM_EXTENSION_FILTER_EXCLUDES));
            this.resourceConfig.register((Object)new ExtensionJerseyFilter(Arrays.asList(excludes)));
        } else {
            this.resourceConfig.register((Object)new ExtensionJerseyFilter());
        }
    }

    private void initServletContainer(FilterConfig config) throws ServletException {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.chainingClassLoader);
        try {
            SLF4J_BRIDGE.install();
            this.servletContainer.init(config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    private void destroyServletContainer() {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.chainingClassLoader);
        try {
            this.servletContainer.destroy();
            SLF4J_BRIDGE.uninstall();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    private void initChainingClassLoader() {
        this.chainingClassLoader = new ChainingClassLoader(RestModuleDescriptor.class.getClassLoader(), Thread.currentThread().getContextClassLoader());
    }
}

