/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.stash.internal.repository.sync.RefResolver;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultRefResolver
implements RefResolver {
    private final RefService refService;

    public DefaultRefResolver(RefService refService) {
        this.refService = refService;
    }

    @Override
    public Branch resolveBranch(@Nonnull Repository repository, @Nonnull String branchId) {
        return (Branch)this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(Objects.requireNonNull(branchId, "branchId")).type((RefType)StandardRefType.BRANCH).build());
    }

    @Override
    public Ref resolveRef(@Nonnull Repository repository, @Nonnull String refId) {
        return this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(Objects.requireNonNull(refId, refId)).build());
    }
}

