/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DefaultRefSyncConfig
implements RefSyncConfig {
    public static final int DEFAULT_COMMAND_SIZE = 32000;
    public static final long DEFAULT_FETCH_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    public static final long DEFAULT_MERGE_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    public static final long DEFAULT_REBASE_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    public static final long DEFAULT_SYNC_DELAY = 30L;
    public static final int DEFAULT_THREADS = 3;
    public static final int MINIMUM_COMMAND_SIZE = 4000;
    public static final long MINIMUM_FETCH_TIMEOUT = TimeUnit.MINUTES.toSeconds(2L);
    public static final long MINIMUM_MERGE_TIMEOUT = TimeUnit.MINUTES.toSeconds(2L);
    public static final long MINIMUM_REBASE_TIMEOUT = TimeUnit.MINUTES.toSeconds(2L);
    public static final String PROP_PREFIX = "plugin.bitbucket-repository-ref-sync.";
    public static final String PROP_FETCH_TIMEOUT = "plugin.bitbucket-repository-ref-sync.fetch.timeout";
    public static final String PROP_MERGE_TIMEOUT = "plugin.bitbucket-repository-ref-sync.merge.timeout";
    public static final String PROP_REBASE_TIMEOUT = "plugin.bitbucket-repository-ref-sync.rebase.timeout";
    public static final String PROP_SYNC_DELAY = "plugin.bitbucket-repository-ref-sync.sync.delay";
    public static final String PROP_THREADS = "plugin.bitbucket-repository-ref-sync.threads";
    public static final String SCM_PROP_ENVIRONMENT_COMMAND_SIZE = "plugin.bitbucket-git.environment.commandsize";
    public static final String SCM_PROP_USE_ALTERNATES = "plugin.bitbucket-git.forks.usealternates";
    private final int commandSize;
    private final Duration fetchTimeout;
    private final Duration mergeTimeout;
    private final boolean possible;
    private final Duration rebaseTimeout;
    private final Duration syncDelay;
    private final int threads;

    public DefaultRefSyncConfig(ApplicationPropertiesService propertiesService) {
        this.fetchTimeout = DefaultRefSyncConfig.getDuration(propertiesService, PROP_FETCH_TIMEOUT, DEFAULT_FETCH_TIMEOUT, MINIMUM_FETCH_TIMEOUT);
        this.mergeTimeout = DefaultRefSyncConfig.getDuration(propertiesService, PROP_MERGE_TIMEOUT, DEFAULT_MERGE_TIMEOUT, MINIMUM_MERGE_TIMEOUT);
        this.rebaseTimeout = DefaultRefSyncConfig.getDuration(propertiesService, PROP_REBASE_TIMEOUT, DEFAULT_REBASE_TIMEOUT, MINIMUM_REBASE_TIMEOUT);
        this.syncDelay = DefaultRefSyncConfig.getDuration(propertiesService, PROP_SYNC_DELAY, 30L, 0L);
        this.threads = Math.max(propertiesService.getPluginProperty(PROP_THREADS, 3), 1);
        this.commandSize = Math.max(propertiesService.getPluginProperty(SCM_PROP_ENVIRONMENT_COMMAND_SIZE, 32000), 4000);
        this.possible = propertiesService.getPluginProperty(SCM_PROP_USE_ALTERNATES, true);
    }

    @Override
    public int getCommandSize() {
        return this.commandSize;
    }

    @Override
    @Nonnull
    public Duration getFetchTimeout() {
        return this.fetchTimeout;
    }

    @Override
    @Nonnull
    public Duration getMergeTimeout() {
        return this.mergeTimeout;
    }

    @Override
    @Nonnull
    public Duration getRebaseTimeout() {
        return this.rebaseTimeout;
    }

    @Override
    @Nonnull
    public Duration getSyncDelay() {
        return this.syncDelay;
    }

    @Override
    public int getThreadCount() {
        return this.threads;
    }

    @Override
    public boolean isPossible() {
        return this.possible;
    }

    @Nonnull
    private static Duration getDuration(@Nonnull ApplicationPropertiesService propertiesService, @Nonnull String key, long defaultValue, long minimumValue) {
        return Duration.ofSeconds(Math.max(propertiesService.getPluginProperty(key, defaultValue), minimumValue));
    }
}

