/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.AbstractProjectVisitor;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.NoSuchTagException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchivedException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessRequest;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessType;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionService;
import com.atlassian.bitbucket.repository.sync.RefAlreadySynchronizedException;
import com.atlassian.bitbucket.repository.sync.RefSyncAction;
import com.atlassian.bitbucket.repository.sync.RefSyncNotAvailableException;
import com.atlassian.bitbucket.repository.sync.RefSyncNotEnabledException;
import com.atlassian.bitbucket.repository.sync.RefSyncRequest;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.bitbucket.repository.sync.RefsSynchronizedEvent;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.git.GitFeature;
import com.atlassian.bitbucket.scm.git.command.rebase.GitRebaseWorkflowsDisabledException;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.repository.sync.AnalyticsRefSyncChangedEvent;
import com.atlassian.stash.internal.repository.sync.BulkRefSyncRequest;
import com.atlassian.stash.internal.repository.sync.InternalRefSyncService;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.RefSyncResult;
import com.atlassian.stash.internal.repository.sync.SimpleRefSyncStatus;
import com.atlassian.stash.internal.repository.sync.SimpleRejectedRef;
import com.atlassian.stash.internal.repository.sync.command.AbstractCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.DiscardRefCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.MergeRefCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.RebaseRefCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.RefSyncCommandFactory;
import com.atlassian.stash.internal.repository.sync.command.ReviewRefsCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.SynchronizeRefsCommandParameters;
import com.atlassian.stash.internal.repository.sync.dao.RefSyncDao;
import com.atlassian.stash.internal.repository.sync.dao.RefSyncNotConfiguredException;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRefSyncService
implements InternalRefSyncService {
    public static final ProjectVisitor<ApplicationUser> TO_OWNER = new AbstractProjectVisitor<ApplicationUser>(){

        public ApplicationUser visit(@Nonnull PersonalProject project) {
            return project.getOwner();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultRefSyncService.class);
    private final AuthenticationContext authenticationContext;
    private final RefSyncConfig config;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final RefRestrictionService refRestrictionService;
    private final RefService refService;
    private final RefSyncCommandFactory refSyncCommandFactory;
    private final RefSyncDao refSyncDao;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final Cache<Integer, Boolean> settingsCache;
    private final TransactionTemplate transactionTemplate;

    public DefaultRefSyncService(AuthenticationContext authenticationContext, RefSyncConfig config, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, PermissionService permissionService, RefSyncCommandFactory refSyncCommandFactory, RefSyncDao refSyncDao, RefRestrictionService refRestrictionService, RefService refService, RepositoryService repositoryService, SecurityService securityService, TransactionTemplate transactionTemplate, CacheFactory cacheFactory) {
        this.authenticationContext = authenticationContext;
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.refSyncDao = refSyncDao;
        this.refSyncCommandFactory = refSyncCommandFactory;
        this.refRestrictionService = refRestrictionService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.transactionTemplate = transactionTemplate;
        this.settingsCache = cacheFactory.getCache("com.atlassian.bitbucket.repository.sync.RefSyncService.settingsCache", this::isEnabled, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build());
    }

    @Override
    @Nonnull
    public Page<RejectedRef> getRejectedRefs(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        return (Page)this.transactionTemplate.execute(() -> this.refSyncDao.getRefs(repository.getId(), pageRequest));
    }

    public RefSyncStatus getStatus(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        RefSyncStatus status = (RefSyncStatus)this.transactionTemplate.execute(() -> this.refSyncDao.getStatus(repository.getId()));
        if (status == null) {
            return null;
        }
        return new SimpleRefSyncStatus.Builder(status).available(this.isAvailable(repository)).build();
    }

    public RejectedRef getStatus(@Nonnull Repository repository, @Nonnull String refId) {
        Objects.requireNonNull(repository, "repository");
        Preconditions.checkArgument((!Objects.requireNonNull(refId, "refId").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank refId is required");
        return (RejectedRef)this.transactionTemplate.execute(() -> this.refSyncDao.getRef(repository.getId(), refId));
    }

    @Override
    public void importRefSync(@Nonnull Repository repository, @Nonnull Stream<RejectedRef> rejectedRefs) {
        this.transactionTemplate.execute(() -> {
            this.refSyncDao.setRejectedRefs(repository.getId(), rejectedRefs);
            this.refSyncDao.setEnabled(repository.getId(), true);
            return null;
        });
        this.settingsCache.remove((Object)repository.getId());
    }

    public boolean isAvailable(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        if (!this.config.isPossible()) {
            return false;
        }
        if (!"git".equals(repository.getScmId())) {
            return false;
        }
        Repository origin = repository.getOrigin();
        if (origin == null) {
            return false;
        }
        Project project = repository.getProject();
        if (project.getType() == ProjectType.PERSONAL) {
            return this.permissionService.hasRepositoryPermission((ApplicationUser)project.accept(TO_OWNER), origin, Permission.REPO_READ);
        }
        return true;
    }

    public boolean isEnabled(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return (Boolean)this.settingsCache.get((Object)repository.getId());
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.settingsCache.removeAll();
        }
    }

    @EventListener
    public void onRepositoryDeleted(@Nonnull RepositoryDeletedEvent event) {
        Integer repositoryId = event.getRepository().getId();
        this.transactionTemplate.execute(() -> {
            this.refSyncDao.cleanup(repositoryId);
            return null;
        });
    }

    @EventListener
    public void onUserCleanup(@Nonnull UserCleanupEvent event) {
        this.transactionTemplate.execute((TransactionCallback)new BulkDisableOperation(event.getDeletedUser()));
    }

    public void setEnabled(@Nonnull Repository repository, boolean enabled) {
        Objects.requireNonNull(repository, "repository");
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.notanadmin", new Object[0]));
        }
        if (enabled && !this.isAvailable(repository)) {
            if (repository.isFork()) {
                ApplicationUser owner = (ApplicationUser)repository.getProject().accept(TO_OWNER);
                Repository upstream = repository.getOrigin();
                throw new RefSyncNotAvailableException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.notavailable.detail", new Object[]{repository.getProject().getKey(), repository.getSlug(), owner.getDisplayName(), owner.getName(), upstream.getProject().getKey(), upstream.getSlug()}));
            }
            throw new RefSyncNotAvailableException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.notafork", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
        DefaultRefSyncService.time(new SetEnabledAndSynchronizeOperation(repository, enabled));
    }

    public void synchronize(@Nonnull RefSyncRequest request) {
        RefSyncAction action = Objects.requireNonNull(request, "request").getAction();
        if (action == RefSyncAction.REBASE && !this.featureManager.isEnabled((Feature)GitFeature.REBASE_WORKFLOWS)) {
            throw new GitRebaseWorkflowsDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.rebase.featuredisabled", new Object[0]));
        }
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.anonymous", new Object[0]));
        }
        Repository repository = request.getRepository();
        String refId = Objects.requireNonNull(request.getRefId(), "refId");
        if (repository.isArchived()) {
            throw new RepositoryArchivedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.archived", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
        if (!this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_WRITE)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.readonly", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
        Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(refId).build());
        if (ref == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.nosuchref", new Object[]{repository.getProject().getKey(), repository.getSlug(), refId});
            if (SimpleRejectedRef.isTag(refId)) {
                throw new NoSuchTagException(message, refId);
            }
            throw new NoSuchBranchException(message, refId);
        }
        RefAccessRequest accessRequest = new RefAccessRequest.Builder(request.getRepository(), RefAccessType.UPDATE).ref((MinimalRef)ref).build();
        if (!this.refRestrictionService.hasPermission(accessRequest)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.unauthorizedref", new Object[]{repository.getProject().getKey(), repository.getSlug(), refId}));
        }
        if (!this.isEnabled(repository)) {
            throw new RefSyncNotEnabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.notenabled", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
        if (!this.isAvailable(repository)) {
            throw new RefSyncNotAvailableException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.notavailable", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
        RejectedRef refStatus = this.getStatus(repository, refId);
        if (refStatus == null) {
            throw new RefAlreadySynchronizedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.alreadyinsync", new Object[]{repository.getProject().getKey(), repository.getSlug(), refId}));
        }
        DefaultRefSyncService.time(switch (action) {
            case RefSyncAction.MERGE -> {
                if (refStatus.getState() != RejectedRefState.DIVERGED) {
                    throw new RefAlreadySynchronizedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.nothingtomerge", new Object[]{repository.getProject().getKey(), repository.getSlug(), refId}));
                }
                yield new MergeOperation(repository, refId, user, request.getContext());
            }
            case RefSyncAction.REBASE -> {
                if (refStatus.getState() != RejectedRefState.DIVERGED) {
                    throw new RefAlreadySynchronizedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.nothingtorebase", new Object[]{repository.getProject().getKey(), repository.getSlug(), refId}));
                }
                yield new RebaseOperation(repository, refId, user);
            }
            case RefSyncAction.DISCARD -> new DiscardOperation(repository, refId, user);
            default -> throw new UnsupportedOperationException(this.i18nService.getMessage("bitbucket.service.repository.refsync.actionnotimplemented", new Object[]{action}));
        });
    }

    @Override
    public void synchronize(@Nonnull BulkRefSyncRequest request) {
        Objects.requireNonNull(request, "request");
        DefaultRefSyncService.time(new SynchronizeOperation(request));
    }

    @Override
    public void updateStatus(@Nonnull BulkRefSyncRequest request) {
        Objects.requireNonNull(request, "request");
        DefaultRefSyncService.time(new ReviewOperation(request));
    }

    private static void time(UncheckedOperation<?> operation) {
        TimerUtils.time((String)operation.toString(), operation);
    }

    private boolean isEnabled(int repositoryId) {
        return (Boolean)this.transactionTemplate.execute(() -> this.refSyncDao.isEnabled(repositoryId));
    }

    private void updateStatus(Repository repository, RefSyncResult result) {
        this.transactionTemplate.execute(() -> {
            try {
                this.refSyncDao.setStatus(repository.getId(), result);
            }
            catch (RefSyncNotConfiguredException e) {
                throw new IllegalStateException("Ref synchronization is not configured for " + repository.getProject().getKey() + "/" + repository.getSlug() + "; status cannot be updated");
            }
            return null;
        });
    }

    private class BulkDisableOperation
    implements PageProvider<Repository>,
    TransactionCallback<Void>,
    UncheckedOperation<Void> {
        private final ApplicationUser user;

        private BulkDisableOperation(ApplicationUser user) {
            this.user = user;
        }

        public Void doInTransaction() {
            return (Void)DefaultRefSyncService.this.securityService.withPermission(Permission.REPO_READ, "Bulk disabling ref synchronization").call((Operation)this);
        }

        @Nonnull
        public Page<Repository> get(@Nonnull PageRequest request) {
            return DefaultRefSyncService.this.repositoryService.findByOwner(this.user, request);
        }

        public Void perform() {
            for (Repository repository : new PagedIterable((PageProvider)this, 25)) {
                if (!repository.isFork()) continue;
                DefaultRefSyncService.this.refSyncDao.setEnabled(repository.getId(), false);
            }
            return null;
        }
    }

    private class SetEnabledAndSynchronizeOperation
    implements UncheckedOperation<Void> {
        private final boolean enabled;
        private final Repository repository;

        private SetEnabledAndSynchronizeOperation(Repository repository, boolean enabled) {
            this.enabled = enabled;
            this.repository = repository;
        }

        public Void perform() {
            DefaultRefSyncService.this.transactionTemplate.execute(() -> {
                DefaultRefSyncService.this.refSyncDao.setEnabled(this.repository.getId(), this.enabled);
                return null;
            });
            DefaultRefSyncService.this.eventPublisher.publish((Object)new AnalyticsRefSyncChangedEvent(this, this.repository, this.enabled));
            DefaultRefSyncService.this.settingsCache.remove((Object)this.repository.getId());
            if (this.enabled) {
                DefaultRefSyncService.time(new SynchronizeOperation(this.repository, DefaultRefSyncService.this.authenticationContext.getCurrentUser()));
            }
            return null;
        }

        public String toString() {
            String status = this.enabled ? "Enabling" : "Disabling";
            return this.repository.getId() + ": " + status + " synchronization";
        }
    }

    private class MergeOperation
    extends AbstractOperation<MergeRefCommandParameters> {
        private MergeOperation(Repository repository, String refId, ApplicationUser user, Map<String, Object> context) {
            super(DefaultRefSyncService.this, (AbstractCommandParameters)new MergeRefCommandParameters(repository, repository.getOrigin(), user, refId, (String)context.get("commitMessage")));
        }

        public String toString() {
            return ((MergeRefCommandParameters)this.parameters).getRepository().getId() + ": Merge " + ((MergeRefCommandParameters)this.parameters).getRefId() + " from " + ((MergeRefCommandParameters)this.parameters).getUpstream().getId();
        }

        @Override
        protected void doPerform() {
            Command<RefChange> command = DefaultRefSyncService.this.refSyncCommandFactory.mergeRef((MergeRefCommandParameters)this.parameters);
            command.setTimeout(DefaultRefSyncService.this.config.getMergeTimeout());
            RefChange change = (RefChange)command.call();
            this.maybeRaiseFor(change);
            DefaultRefSyncService.this.transactionTemplate.execute(() -> {
                DefaultRefSyncService.this.refSyncDao.updateRef(((MergeRefCommandParameters)this.parameters).getRepository().getId(), ((MergeRefCommandParameters)this.parameters).getRefId(), RejectedRefState.AHEAD);
                return null;
            });
        }
    }

    private class RebaseOperation
    extends AbstractOperation<RebaseRefCommandParameters> {
        private RebaseOperation(Repository repository, String refId, ApplicationUser user) {
            super(DefaultRefSyncService.this, (AbstractCommandParameters)new RebaseRefCommandParameters(repository, repository.getOrigin(), user, refId));
        }

        public String toString() {
            return ((RebaseRefCommandParameters)this.parameters).getRepository().getId() + ": Rebase " + ((RebaseRefCommandParameters)this.parameters).getRefId() + " on " + ((RebaseRefCommandParameters)this.parameters).getUpstream().getId();
        }

        @Override
        protected void doPerform() {
            Command<RefChange> command = DefaultRefSyncService.this.refSyncCommandFactory.rebaseRef((RebaseRefCommandParameters)this.parameters);
            command.setTimeout(DefaultRefSyncService.this.config.getRebaseTimeout());
            RefChange change = (RefChange)command.call();
            this.maybeRaiseFor(change);
            DefaultRefSyncService.this.transactionTemplate.execute(() -> {
                DefaultRefSyncService.this.refSyncDao.updateRef(((RebaseRefCommandParameters)this.parameters).getRepository().getId(), ((RebaseRefCommandParameters)this.parameters).getRefId(), RejectedRefState.AHEAD);
                return null;
            });
        }
    }

    private class DiscardOperation
    extends AbstractOperation<DiscardRefCommandParameters> {
        private DiscardOperation(Repository repository, String refId, ApplicationUser user) {
            super(DefaultRefSyncService.this, (AbstractCommandParameters)new DiscardRefCommandParameters(repository, repository.getOrigin(), user, refId));
        }

        public String toString() {
            return ((DiscardRefCommandParameters)this.parameters).getRepository().getId() + ": Discard " + ((DiscardRefCommandParameters)this.parameters).getRefId() + " for " + ((DiscardRefCommandParameters)this.parameters).getUpstream().getId();
        }

        @Override
        protected void doPerform() {
            RefChange change = (RefChange)DefaultRefSyncService.this.refSyncCommandFactory.discardRef((DiscardRefCommandParameters)this.parameters).call();
            this.maybeRaiseFor(change);
            DefaultRefSyncService.this.transactionTemplate.execute(() -> {
                DefaultRefSyncService.this.refSyncDao.removeRef(((DiscardRefCommandParameters)this.parameters).getRepository().getId(), ((DiscardRefCommandParameters)this.parameters).getRefId());
                return null;
            });
        }
    }

    private class SynchronizeOperation
    extends AbstractOperation<SynchronizeRefsCommandParameters> {
        private SynchronizeOperation(BulkRefSyncRequest request) {
            super(DefaultRefSyncService.this, (AbstractCommandParameters)new SynchronizeRefsCommandParameters(request));
        }

        private SynchronizeOperation(Repository repository, ApplicationUser user) {
            super(DefaultRefSyncService.this, (AbstractCommandParameters)new SynchronizeRefsCommandParameters(repository, repository.getOrigin(), user));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(64).append(((SynchronizeRefsCommandParameters)this.parameters).getRepository().getId()).append(": ");
            if (((SynchronizeRefsCommandParameters)this.parameters).isFull()) {
                builder.append("Full synchronization");
            } else {
                builder.append("Incremental synchronization for ").append(((SynchronizeRefsCommandParameters)this.parameters).size()).append(" refs");
            }
            return builder.toString();
        }

        @Override
        protected void doPerform() {
            RefSyncResult result = (RefSyncResult)DefaultRefSyncService.this.refSyncCommandFactory.synchronizeRefs((SynchronizeRefsCommandParameters)this.parameters).call();
            if (result == null) {
                return;
            }
            log.debug("{}: Synchronized {}/{} ref(s) from {} ({} rejected)", new Object[]{((SynchronizeRefsCommandParameters)this.parameters).getRepository(), result.getChangedRefs().size(), ((SynchronizeRefsCommandParameters)this.parameters).size(), ((SynchronizeRefsCommandParameters)this.parameters).getUpstream(), result.getRejectedRefs().size()});
            if (!result.isEmpty()) {
                this.raise(new RefsSynchronizedEvent((Object)DefaultRefSyncService.this, ((SynchronizeRefsCommandParameters)this.parameters).getRepository(), result.getChangedRefs(), result.getRejectedRefs(), ((SynchronizeRefsCommandParameters)this.parameters).getUpstream(), (Iterable)((Object)this.parameters)));
            }
            DefaultRefSyncService.this.updateStatus(((SynchronizeRefsCommandParameters)this.parameters).getRepository(), result);
        }
    }

    private class ReviewOperation
    extends AbstractOperation<ReviewRefsCommandParameters> {
        private ReviewOperation(BulkRefSyncRequest request) {
            super(DefaultRefSyncService.this, (AbstractCommandParameters)new ReviewRefsCommandParameters(request));
        }

        public String toString() {
            return ((ReviewRefsCommandParameters)this.parameters).getRepository().getId() + ": Synchronization review";
        }

        @Override
        protected void doPerform() {
            RefSyncResult result = (RefSyncResult)DefaultRefSyncService.this.refSyncCommandFactory.reviewRefs((ReviewRefsCommandParameters)this.parameters).call();
            if (result != null && !result.isEmpty()) {
                DefaultRefSyncService.this.updateStatus(((ReviewRefsCommandParameters)this.parameters).getRepository(), result);
            }
        }
    }

    private static abstract class AbstractOperation<T extends AbstractCommandParameters>
    implements UncheckedOperation<Void> {
        protected final T parameters;
        final /* synthetic */ DefaultRefSyncService this$0;

        protected AbstractOperation(T parameters) {
            this.this$0 = var1_1;
            this.parameters = parameters;
        }

        public Void perform() {
            this.doPerform();
            return null;
        }

        protected abstract void doPerform();

        protected void maybeRaiseFor(@Nullable RefChange change) {
            if (change != null) {
                this.raise(new RefsSynchronizedEvent((Object)this.this$0, ((AbstractCommandParameters)this.parameters).getRepository(), ((AbstractCommandParameters)this.parameters).getUpstream(), change));
            }
        }

        protected void raise(@Nonnull RefsSynchronizedEvent event) {
            this.this$0.eventPublisher.publish((Object)event);
        }
    }
}

