/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.stash.internal.repository.sync.dao.AoRefSyncConfig;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;
import java.util.Set;

public class SimpleRefSyncStatus
implements RefSyncStatus {
    private final Set<RejectedRef> aheadRefs;
    private final boolean available;
    private final Set<RejectedRef> divergedRefs;
    private final boolean enabled;
    private final Date lastSync;
    private final Set<RejectedRef> orphanedRefs;

    private SimpleRefSyncStatus(Date lastSync, boolean available, boolean enabled, Set<RejectedRef> aheadRefs, Set<RejectedRef> divergedRefs, Set<RejectedRef> orphanedRefs) {
        this.aheadRefs = aheadRefs;
        this.available = available;
        this.divergedRefs = divergedRefs;
        this.enabled = enabled;
        this.lastSync = lastSync;
        this.orphanedRefs = orphanedRefs;
    }

    @Nonnull
    public Date getLastSync() {
        return this.lastSync;
    }

    @Nonnull
    public Set<RejectedRef> getAheadRefs() {
        return this.aheadRefs;
    }

    @Nonnull
    public Set<RejectedRef> getDivergedRefs() {
        return this.divergedRefs;
    }

    @Nonnull
    public Set<RejectedRef> getOrphanedRefs() {
        return this.orphanedRefs;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private final ImmutableSet.Builder<RejectedRef> aheadRefs = ImmutableSet.builder();
        private final ImmutableSet.Builder<RejectedRef> divergedRefs = ImmutableSet.builder();
        private final ImmutableSet.Builder<RejectedRef> orphanedRefs = ImmutableSet.builder();
        private boolean available;
        private boolean enabled;
        private Date lastSync;

        public Builder() {
        }

        public Builder(@Nonnull RefSyncStatus status) {
            this();
            this.aheadRefs.addAll((Iterable)Objects.requireNonNull(status, "status").getAheadRefs());
            this.available = status.isAvailable();
            this.divergedRefs.addAll((Iterable)status.getDivergedRefs());
            this.enabled = status.isEnabled();
            this.lastSync = status.getLastSync();
            this.orphanedRefs.addAll((Iterable)status.getOrphanedRefs());
        }

        public Builder(@Nonnull AoRefSyncConfig config) {
            this();
            this.enabled = Objects.requireNonNull(config, "config").isEnabled();
            this.lastSync = config.getLastSync();
        }

        public SimpleRefSyncStatus build() {
            return new SimpleRefSyncStatus(this.lastSync, this.available, this.enabled, (Set<RejectedRef>)this.aheadRefs.build(), (Set<RejectedRef>)this.divergedRefs.build(), (Set<RejectedRef>)this.orphanedRefs.build());
        }

        public Builder available(boolean value) {
            this.available = value;
            return this;
        }

        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder lastSync(@Nonnull Date value) {
            this.lastSync = Objects.requireNonNull(value, "lastSync");
            return this;
        }

        public Builder rejectedRef(@Nonnull RejectedRef value) {
            this.bucketFor(value).add((Object)value);
            return this;
        }

        private ImmutableSet.Builder<RejectedRef> bucketFor(RejectedRef value) {
            switch (Objects.requireNonNull(value, "rejectedRef").getState()) {
                case AHEAD: {
                    return this.aheadRefs;
                }
                case DIVERGED: {
                    return this.divergedRefs;
                }
                case ORPHANED: {
                    return this.orphanedRefs;
                }
            }
            throw new IllegalArgumentException("RejectedRefState." + String.valueOf(value.getState()) + " is not supported");
        }
    }
}

