/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.atst;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RefSyncService;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.troubleshooting.spi.SupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.text.DateFormat;
import java.util.Locale;

public class RefSyncSupportData
implements SupportDataAppender<Repository> {
    private static final DateFormat FORMAT = DateFormat.getDateTimeInstance(0, 0, Locale.US);
    private static final String REF_SYNC = "bitbucket.atst.refsync";
    private static final String REF_SYNC_AHEAD = "bitbucket.atst.refsync.ahead";
    private static final String REF_SYNC_DIVERGED = "bitbucket.atst.refsync.diverged";
    private static final String REF_SYNC_ENABLED = "bitbucket.atst.refsync.enabled";
    private static final String REF_SYNC_LAST_SYNC = "bitbucket.atst.refsync.lastsync";
    private static final String REF_SYNC_ORPHANED = "bitbucket.atst.refsync.orphaned";
    private final RefSyncService refSyncService;

    public RefSyncSupportData(RefSyncService refSyncService) {
        this.refSyncService = refSyncService;
    }

    public void addSupportData(SupportDataBuilder supportDataBuilder, Repository repository) {
        RefSyncStatus status = this.refSyncService.getStatus(repository);
        if (status == null) {
            return;
        }
        SupportDataBuilder refSync = supportDataBuilder.addCategory(REF_SYNC);
        refSync.addValue(REF_SYNC_ENABLED, Boolean.toString(status.isEnabled()));
        refSync.addValue(REF_SYNC_LAST_SYNC, FORMAT.format(status.getLastSync()));
        if (status.isEnabled()) {
            refSync.addValue(REF_SYNC_AHEAD, Integer.toString(status.getAheadRefs().size()));
            refSync.addValue(REF_SYNC_DIVERGED, Integer.toString(status.getDivergedRefs().size()));
            refSync.addValue(REF_SYNC_ORPHANED, Integer.toString(status.getOrphanedRefs().size()));
        }
    }
}

