/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.dmz.process.LineStdinHandler;
import com.atlassian.bitbucket.dmz.process.LineStdoutHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.CommandUsageException;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.fetch.GitFetchBuilder;
import com.atlassian.bitbucket.scm.git.command.fetch.GitFetchTagMode;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevListBuilder;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevListWalk;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.stash.internal.repository.sync.RefResolver;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.RefSyncResult;
import com.atlassian.stash.internal.repository.sync.command.AbstractSynchronizeRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.FetchCallback;
import com.atlassian.stash.internal.repository.sync.command.FetchCommandHandler;
import com.atlassian.stash.internal.repository.sync.command.SynchronizeRefsCommandParameters;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFetchSynchronizeRefsCommand
extends AbstractSynchronizeRefsCommand<SynchronizeRefsCommandParameters> {
    private static final Predicate<String> IS_SHORT = hash -> hash.length() != 40;
    private static final Function<RefChange, List<String>> TO_HASHES = change -> Arrays.asList(change.getFromHash(), change.getToHash());
    private static final Logger log = LoggerFactory.getLogger(AbstractFetchSynchronizeRefsCommand.class);
    private final I18nService i18nService;

    protected AbstractFetchSynchronizeRefsCommand(GitCommandBuilderFactory builderFactory, RefSyncConfig config, I18nService i18nService, RefResolver refResolver, SynchronizeRefsCommandParameters parameters) {
        super(builderFactory, config, refResolver, parameters);
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public RefSyncResult call() {
        return this.resolveRefs(super.call());
    }

    @Nonnull
    protected GitFetchBuilder fetchBuilder() {
        return (GitFetchBuilder)((GitFetchBuilder)this.builder().fetch().author(this.authorName, this.authorEmail)).repository(((SynchronizeRefsCommandParameters)this.parameters).getUpstream()).tags(GitFetchTagMode.NO_TAGS).withConfiguration("gc.auto", 0L);
    }

    protected void runFetch(@Nonnull GitFetchBuilder builder, @Nonnull FetchCallback callback) {
        GitCommand<Void> command = new FetchCommandHandler(this.i18nService, callback, this.refResolver, ((SynchronizeRefsCommandParameters)this.parameters).getRepository()).build(builder);
        command.setTimeout(this.config.getFetchTimeout());
        command.call();
    }

    @Nonnull
    private RefSyncResult resolveRefs(@Nonnull RefSyncResult result) {
        List shortHashes = Chainable.chain(result.getChangedRefs()).flatMap(TO_HASHES).filter(IS_SHORT).toList();
        if (!shortHashes.isEmpty()) {
            Map hashes;
            log.debug("Resolving full hashes for {} short hashes", (Object)shortHashes.size());
            try {
                hashes = (Map)((GitRevListBuilder)((GitRevListBuilder)((GitRevListBuilder)((GitRevListBuilder)this.builder().revList().format("%h%x02%H")).ignoreMissing(true)).inputHandler((CommandInputHandler)new LineStdinHandler((Iterable)shortHashes))).walk(GitRevListWalk.NO_WALK)).build((CommandOutputHandler)new MapHashesStdoutHandler()).call();
            }
            catch (CommandUsageException e) {
                hashes = null;
            }
            if (hashes == null || hashes.isEmpty()) {
                log.warn("{} short hashes could not be resolved. This means one or more RefChanges will not have full 40-byte hashes. This may cause unexpected behaviour.", (Object)shortHashes.size());
            } else {
                RefSyncResult.Builder builder = new RefSyncResult.Builder().changedRefs(Collections2.transform(result.getChangedRefs(), new Resolver(hashes)::apply)).rejectedRefs(result.getRejectedRefs());
                if (result.isSynchronized()) {
                    builder.isSynchronized();
                }
                result = builder.build();
            }
        }
        return result;
    }

    private static class MapHashesStdoutHandler
    extends LineStdoutHandler<Map<String, String>> {
        private final Map<String, String> hashes = Maps.newHashMap();

        private MapHashesStdoutHandler() {
            super(StandardCharsets.UTF_8);
        }

        public Map<String, String> getOutput() {
            return this.hashes;
        }

        protected boolean onStdout(@Nonnull String line, boolean truncated) {
            String[] split = line.split("\u0002", 2);
            if (split.length == 2) {
                this.hashes.put(split[0], split[1]);
            }
            return true;
        }
    }

    private static class Resolver
    implements Function<RefChange, RefChange> {
        private final Map<String, String> hashes;

        private Resolver(Map<String, String> hashes) {
            this.hashes = hashes;
        }

        @Override
        public RefChange apply(RefChange change) {
            return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder(change).fromHash(this.resolve(change.getFromHash()))).toHash(this.resolve(change.getToHash()))).build();
        }

        private String resolve(String hash) {
            return IS_SHORT.test(hash) ? (String)MoreObjects.firstNonNull((Object)this.hashes.get(hash), (Object)hash) : hash;
        }
    }
}

