/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.repository.sync.BulkRefSyncRequest;
import com.atlassian.stash.internal.repository.sync.command.AbstractCommandParameters;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public abstract class AbstractRefsCommandParameters
extends AbstractCommandParameters
implements Iterable<RefChange> {
    protected final Collection<RefChange> refChanges;

    protected AbstractRefsCommandParameters(BulkRefSyncRequest request) {
        super(request.getRepository(), request.getUpstream(), request.getUser());
        this.refChanges = Objects.requireNonNull(request.getRefChanges(), "refChanges");
    }

    protected AbstractRefsCommandParameters(Repository repository, Repository upstream, ApplicationUser user) {
        super(repository, upstream, user);
        this.refChanges = null;
    }

    @Override
    public Iterator<RefChange> iterator() {
        if (this.refChanges == null) {
            return Collections.emptyIterator();
        }
        return this.refChanges.iterator();
    }

    public int size() {
        return this.refChanges == null ? 0 : this.refChanges.size();
    }
}

