/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.SimpleCommand;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRef;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefBuilderSupport;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefSetBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.repository.sync.RefResolver;
import com.atlassian.stash.internal.repository.sync.command.DiscardRefCommandParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscardRefCommand
extends SimpleCommand<RefChange> {
    private static final Logger log = LoggerFactory.getLogger(DiscardRefCommand.class);
    private final GitCommandBuilderFactory builderFactory;
    private final String refId;
    private final RefResolver refResolver;
    private final Repository repository;
    private final Repository upstream;
    private final ApplicationUser user;

    public DiscardRefCommand(GitCommandBuilderFactory builderFactory, RefResolver refResolver, DiscardRefCommandParameters parameters) {
        this.builderFactory = builderFactory;
        this.refResolver = refResolver;
        this.refId = parameters.getRefId();
        this.repository = parameters.getRepository();
        this.upstream = parameters.getUpstream();
        this.user = parameters.getUser();
    }

    public RefChange call() {
        GitUpdateRefSetBuilder commandBuilder;
        Ref toRef = this.refResolver.resolveRef(this.repository, this.refId);
        if (toRef == null) {
            log.debug("{}: {} has already been deleted", (Object)this.repository, (Object)this.refId);
            return null;
        }
        Ref fromRef = this.refResolver.resolveRef(this.upstream, this.refId);
        SimpleRefChange.Builder changeBuilder = (SimpleRefChange.Builder)new SimpleRefChange.Builder().from(toRef);
        GitUpdateRef updateRef = this.builderFactory.builder(this.repository).updateRef();
        if (fromRef == null) {
            log.debug("{}: Deleting {}, which has been deleted upstream in {}", new Object[]{this.repository, this.refId, this.upstream});
            ((SimpleRefChange.Builder)changeBuilder.toHash(GitUtils.NULL_SHA1)).type(RefChangeType.DELETE);
            commandBuilder = updateRef.delete(this.refId);
        } else {
            ((SimpleRefChange.Builder)changeBuilder.to(fromRef)).type(RefChangeType.UPDATE);
            commandBuilder = updateRef.set(this.refId, fromRef.getLatestCommit());
        }
        ((GitUpdateRefBuilderSupport)commandBuilder.author(this.user)).build().call();
        return changeBuilder.build();
    }
}

