/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.dmz.process.LinePump;
import com.atlassian.bitbucket.dmz.process.LineStdoutHandler;
import com.atlassian.bitbucket.dmz.process.NioStderrHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.Watchdog;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.bitbucket.scm.git.command.fetch.GitFetchBuilder;
import com.atlassian.stash.internal.repository.sync.RefResolver;
import com.atlassian.stash.internal.repository.sync.command.FetchCallback;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchCommandHandler {
    public static final Pattern PATTERN_LOCK_FAILED = Pattern.compile("fatal: Unable to create '.+/(refs/heads/[^']+)\\.lock': File exists\\.");
    public static final Pattern PATTERN_REMOTE_REF = Pattern.compile("fatal: [Cc]ouldn't find remote ref (refs/heads/.*)");
    private static final Logger log = LoggerFactory.getLogger(FetchCommandHandler.class);
    private final FetchCallback context;
    private final StringBuilder errors;
    private final I18nService i18nService;
    private final RefResolver refResolver;
    private final Repository repository;
    private int rejected;

    public FetchCommandHandler(@Nonnull I18nService i18nService, @Nonnull FetchCallback context, @Nonnull RefResolver refResolver, @Nonnull Repository repository) {
        this.context = context;
        this.i18nService = i18nService;
        this.refResolver = refResolver;
        this.repository = repository;
        this.errors = new StringBuilder();
    }

    public GitCommand<Void> build(GitFetchBuilder builder) {
        return ((GitFetchBuilder)builder.errorHandler((CommandErrorHandler)new RefHandler()).exitHandler((CommandExitHandler)new FetchExitHandler(this.i18nService, this.repository))).build((CommandOutputHandler)new RefHandler());
    }

    private void processRef(String line) {
        if (StringUtils.isBlank((CharSequence)line) || line.charAt(0) != ' ') {
            if (this.errors.length() > 0) {
                this.errors.append('\n');
            }
            this.errors.append(line);
            return;
        }
        char hint = line.charAt(1);
        int changeEnd = line.indexOf(32, 20);
        String change = line.substring(3, changeEnd).trim();
        String name = line.substring(changeEnd);
        int split = name.indexOf(" -> ");
        if (split != -1) {
            name = name.substring(0, split);
        }
        String refId = GitRefPattern.HEADS.qualify(name.trim());
        if (hint == '*') {
            this.context.onChanged(this.buildAddRefChange(refId));
        } else if (hint == '!') {
            this.context.onRejected(refId, RejectedRefState.DIVERGED);
            ++this.rejected;
        } else {
            if (hint == '-' || hint == 'x' || hint == 't') {
                throw new IllegalStateException("Unexpected ref change: " + line);
            }
            split = change.indexOf("..");
            String fromHash = change.substring(0, split);
            String toHash = change.substring(split + 2);
            this.context.onChanged(this.buildUpdateRefChange(refId, fromHash, toHash));
        }
    }

    private RefChange buildAddRefChange(String refId) {
        Branch branch = this.refResolver.resolveBranch(this.repository, refId);
        if (branch == null) {
            throw new IllegalStateException("git fetch updated " + refId + ", but the ref does not exist");
        }
        return FetchCommandHandler.buildRefChange(refId, RefChangeType.ADD, GitUtils.NULL_SHA1, branch.getLatestCommit());
    }

    private RefChange buildUpdateRefChange(String refId, String fromHash, String toHash) {
        return FetchCommandHandler.buildRefChange(refId, RefChangeType.UPDATE, fromHash, toHash);
    }

    private static RefChange buildRefChange(String id, RefChangeType type, String fromHash, String toHash) {
        return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().fromHash(fromHash)).ref((MinimalRef)((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(GitRefPattern.HEADS.unqualify(id))).id(id)).type((RefType)StandardRefType.BRANCH).build())).toHash(toHash)).type(type)).build();
    }

    private class RefHandler
    extends LineStdoutHandler<Void>
    implements NioStderrHandler {
        private RefHandler() {
            super(StandardCharsets.UTF_8, LinePump.Mode.CRLF_OR_LF);
        }

        public void complete() {
        }

        public void process(@Nonnull InputStream output) {
            throw new UnsupportedOperationException("BIO output is not supported");
        }

        public void setWatchdog(@Nonnull Watchdog watchdog) {
            throw new UnsupportedOperationException("BIO output is not supported");
        }

        public Void getOutput() {
            return null;
        }

        public boolean isNioOnly() {
            return true;
        }

        public void onStderr(@Nonnull ByteBuffer buffer, boolean closed) {
            this.onStdout(buffer, closed);
        }

        protected boolean onStdout(@Nonnull String line, boolean truncated) {
            FetchCommandHandler.this.processRef(line);
            return true;
        }
    }

    @Deprecated
    private class FetchExitHandler
    extends GitCommandExitHandler {
        private FetchExitHandler(I18nService i18nService, Repository repository) {
            super(i18nService, repository);
        }

        public void onExit(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
            super.onExit(command, exitCode, FetchCommandHandler.this.errors.toString(), thrown);
        }

        protected boolean isError(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
            if (FetchCommandHandler.this.rejected > 0 && (exitCode != 0 || this.isNonZeroExitCodeException(thrown))) {
                return false;
            }
            Matcher matcher = PATTERN_LOCK_FAILED.matcher(stdErr);
            if (matcher.find()) {
                String ref = matcher.group(1);
                log.warn("{}: Refs could not be synchronized; {} is locked by another process", (Object)this.repository, (Object)ref);
                return false;
            }
            matcher = PATTERN_REMOTE_REF.matcher(stdErr);
            if (matcher.find()) {
                String ref = matcher.group(1);
                log.warn("{}: Refs could not be synchronized; {} no longer exists", (Object)this.repository, (Object)ref);
                return false;
            }
            return super.isError(command, exitCode, stdErr, thrown);
        }
    }
}

