/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.stash.internal.repository.sync.RefResolver;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.RefSyncResult;
import com.atlassian.stash.internal.repository.sync.command.DiscardRefCommand;
import com.atlassian.stash.internal.repository.sync.command.DiscardRefCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.FullSynchronizeRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.IncrementalSynchronizeRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.MergeRefCommand;
import com.atlassian.stash.internal.repository.sync.command.MergeRefCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.RebaseRefCommand;
import com.atlassian.stash.internal.repository.sync.command.RebaseRefCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.RefSyncCommandFactory;
import com.atlassian.stash.internal.repository.sync.command.ReviewRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.ReviewRefsCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.SynchronizeRefsCommandParameters;
import jakarta.annotation.Nonnull;

public class GitRefSyncCommandFactory
implements RefSyncCommandFactory {
    private final GitCommandBuilderFactory builderFactory;
    private final GitExtendedCommandFactory commandFactory;
    private final RefSyncConfig config;
    private final I18nService i18nService;
    private final RefResolver refResolver;

    public GitRefSyncCommandFactory(GitCommandBuilderFactory builderFactory, GitExtendedCommandFactory commandFactory, RefSyncConfig config, I18nService i18nService, RefResolver refResolver) {
        this.builderFactory = builderFactory;
        this.commandFactory = commandFactory;
        this.config = config;
        this.i18nService = i18nService;
        this.refResolver = refResolver;
    }

    @Override
    @Nonnull
    public Command<RefChange> discardRef(@Nonnull DiscardRefCommandParameters parameters) {
        return new DiscardRefCommand(this.builderFactory, this.refResolver, parameters);
    }

    @Override
    @Nonnull
    public Command<RefChange> mergeRef(@Nonnull MergeRefCommandParameters parameters) {
        return new MergeRefCommand(this.commandFactory, this.i18nService, this.refResolver, parameters);
    }

    @Override
    @Nonnull
    public Command<RefChange> rebaseRef(@Nonnull RebaseRefCommandParameters parameters) {
        return new RebaseRefCommand(this.commandFactory, this.i18nService, this.refResolver, parameters);
    }

    @Override
    @Nonnull
    public Command<RefSyncResult> reviewRefs(@Nonnull ReviewRefsCommandParameters parameters) {
        return new ReviewRefsCommand(this.builderFactory, this.config, this.refResolver, parameters);
    }

    @Override
    @Nonnull
    public Command<RefSyncResult> synchronizeRefs(@Nonnull SynchronizeRefsCommandParameters parameters) {
        if (parameters.isFull()) {
            return new FullSynchronizeRefsCommand(this.builderFactory, this.config, this.i18nService, this.refResolver, parameters);
        }
        return new IncrementalSynchronizeRefsCommand(this.builderFactory, this.config, this.i18nService, this.refResolver, parameters);
    }
}

