/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.fetch.GitFetchBuilder;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefDeleteBuilder;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefSetBuilder;
import com.atlassian.stash.internal.repository.sync.RefResolver;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.SimpleRejectedRef;
import com.atlassian.stash.internal.repository.sync.command.AbstractFetchSynchronizeRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.FetchCallback;
import com.atlassian.stash.internal.repository.sync.command.SynchronizeRefsCommandParameters;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSynchronizeRefsCommand
extends AbstractFetchSynchronizeRefsCommand {
    private static final Logger log = LoggerFactory.getLogger(IncrementalSynchronizeRefsCommand.class);
    private final int commandSize;

    public IncrementalSynchronizeRefsCommand(GitCommandBuilderFactory builderFactory, RefSyncConfig config, I18nService i18nService, RefResolver refResolver, SynchronizeRefsCommandParameters parameters) {
        super(builderFactory, config, i18nService, refResolver, parameters);
        this.commandSize = config.getCommandSize();
    }

    public String toString() {
        return ((SynchronizeRefsCommandParameters)this.parameters).getRepository().getId() + ": Incremental synchronization for " + ((SynchronizeRefsCommandParameters)this.parameters).size() + " refs";
    }

    @Override
    protected boolean synchronize() {
        List<RefChange> toFetch = this.applyRefChanges();
        if (toFetch.isEmpty()) {
            log.debug("{} All changes were applied using update-ref", (Object)((SynchronizeRefsCommandParameters)this.parameters).getRepository());
        } else {
            log.debug("{} Attempting to update {} refs using fetch", (Object)((SynchronizeRefsCommandParameters)this.parameters).getRepository(), (Object)toFetch.size());
            this.fetchRefs(toFetch);
        }
        return true;
    }

    private static String toRefspec(RefChange change) {
        return change.getRef().getId() + ":" + change.getRef().getId();
    }

    private List<RefChange> applyRefChanges() {
        ArrayList toFetch = Lists.newArrayList();
        for (RefChange change : (SynchronizeRefsCommandParameters)this.parameters) {
            if (change.getRef() == null || StringUtils.isBlank((CharSequence)change.getRef().getId())) {
                log.warn("{}: Ignoring invalid RefChange; refId is blank", (Object)((SynchronizeRefsCommandParameters)this.parameters).getRepository());
                continue;
            }
            if (SimpleRejectedRef.isNote(change.getRef().getId())) continue;
            if (change.getType() == RefChangeType.DELETE) {
                this.deleteRef(change);
                continue;
            }
            if (StandardRefType.TAG.equals((Object)change.getRef().getType())) {
                this.setTag(change);
                continue;
            }
            toFetch.add(change);
        }
        return toFetch;
    }

    private void deleteRef(@Nonnull RefChange change) {
        try {
            ((GitUpdateRefDeleteBuilder)((GitUpdateRefDeleteBuilder)this.builder().updateRef().delete(change.getRef().getId()).author(this.authorName, this.authorEmail)).oldValue(change.getFromHash())).build().call();
            this.addChangedRef(change);
        }
        catch (NoSuchCommitException noSuchCommitException) {
        }
        catch (ServiceException e) {
            this.addRejectedRef(change.getRef().getId(), RejectedRefState.ORPHANED);
        }
    }

    private void fetchRefs(List<RefChange> changes) {
        GitFetchBuilder builder = this.fetchBuilder();
        IncrementalFetchCallback callback = new IncrementalFetchCallback();
        int refspecLength = 0;
        for (RefChange change : changes) {
            String refspec = IncrementalSynchronizeRefsCommand.toRefspec(change);
            if (!callback.isEmpty() && refspecLength + refspec.length() > this.commandSize) {
                log.debug("Running partial git fetch; the command line is too long ({})", (Object)refspecLength);
                this.runFetch(builder, callback);
                builder.clearRefspecs();
            }
            builder.refspec(refspec);
            callback.add(change);
            refspecLength += refspec.length() + 1;
        }
        this.runFetch(builder, callback);
    }

    private void runFetch(@Nonnull GitFetchBuilder builder, @Nonnull IncrementalFetchCallback callback) {
        super.runFetch(builder, callback);
        callback.done();
    }

    private void setTag(@Nonnull RefChange change) {
        String refId = change.getRef().getId();
        if (StringUtils.isBlank((CharSequence)change.getToHash())) {
            log.warn("{}: Not synchronizing {}; the toHash was not supplied", (Object)((SynchronizeRefsCommandParameters)this.parameters).getRepository(), (Object)refId);
            return;
        }
        try {
            ((GitUpdateRefSetBuilder)((GitUpdateRefSetBuilder)this.builder().updateRef().set(refId, change.getToHash()).author(this.authorName, this.authorEmail)).oldValue(change.getFromHash())).build().call();
            this.addChangedRef(change);
        }
        catch (ServiceException e) {
            this.addRejectedRef(refId, RejectedRefState.AHEAD);
        }
    }

    private class IncrementalFetchCallback
    implements FetchCallback {
        private final Set<String> fetched = Sets.newHashSet();
        private final Map<String, RefChange> fetching = Maps.newHashMap();

        private IncrementalFetchCallback() {
        }

        public void add(RefChange change) {
            this.fetching.put(change.getRef().getId(), change);
        }

        public void done() {
            this.fetching.keySet().removeAll(this.fetched);
            for (RefChange change : this.fetching.values()) {
                IncrementalSynchronizeRefsCommand.this.addChangedRef(change);
            }
            this.fetched.clear();
            this.fetching.clear();
        }

        public boolean isEmpty() {
            return this.fetching.isEmpty();
        }

        @Override
        public void onChanged(@Nonnull RefChange change) {
            this.fetched.add(change.getRef().getId());
            IncrementalSynchronizeRefsCommand.this.addChangedRef(change);
        }

        @Override
        public void onRejected(@Nonnull String refId, @Nonnull RejectedRefState state) {
            this.fetched.add(refId);
            IncrementalSynchronizeRefsCommand.this.addRejectedRef(refId, state);
        }
    }
}

