/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.MergeCommandParameters;
import com.atlassian.bitbucket.scm.SimpleCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.repository.sync.RefResolver;
import com.atlassian.stash.internal.repository.sync.SimpleRejectedRef;
import com.atlassian.stash.internal.repository.sync.command.MergeRefCommandParameters;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRefCommand
extends SimpleCommand<RefChange> {
    private static final Logger log = LoggerFactory.getLogger(MergeRefCommand.class);
    private final GitExtendedCommandFactory commandFactory;
    private final I18nService i18nService;
    private final String message;
    private final String refId;
    private final RefResolver refResolver;
    private final Repository repository;
    private final Repository upstream;
    private final ApplicationUser user;
    private long executionTimeout;
    private long idleTimeout;

    public MergeRefCommand(GitExtendedCommandFactory commandFactory, I18nService i18nService, RefResolver refResolver, MergeRefCommandParameters parameters) {
        this.commandFactory = commandFactory;
        this.i18nService = i18nService;
        this.refResolver = refResolver;
        this.message = parameters.getMessage();
        this.refId = parameters.getRefId();
        this.repository = parameters.getRepository();
        this.upstream = parameters.getUpstream();
        this.user = parameters.getUser();
    }

    public RefChange call() {
        if (SimpleRejectedRef.isTag(this.refId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.merge.tag", new Object[0]));
        }
        Branch toBranch = this.refResolver.resolveBranch(this.repository, this.refId);
        if (toBranch == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.merge.nosuchbranch", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.refId});
            throw new NoSuchCommitException(message, this.refId);
        }
        Branch fromBranch = this.refResolver.resolveBranch(this.upstream, this.refId);
        if (fromBranch == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.merge.nothingupstream", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.refId, this.upstream.getProject().getKey(), this.upstream.getSlug()});
            throw new NoSuchCommitException(message, this.refId);
        }
        if (StringUtils.equals((CharSequence)fromBranch.getLatestCommit(), (CharSequence)toBranch.getLatestCommit())) {
            log.debug("{}/{}:{} is already in sync with {}/{} ({})", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.refId, this.upstream.getProject().getKey(), this.upstream.getSlug(), toBranch.getLatestCommit()});
            return null;
        }
        GitCommand command = this.commandFactory.merge(this.repository, ((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)((MergeCommandParameters.Builder)new MergeCommandParameters.Builder().author(this.user)).fromBranch(fromBranch.getId())).fromCommitId(fromBranch.getLatestCommit())).fromRepository(this.upstream)).message(this.message)).toBranch(this.refId)).build());
        command.setExecutionTimeout(this.executionTimeout);
        command.setIdleTimeout(this.idleTimeout);
        Branch branch = (Branch)command.call();
        return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().from((Ref)toBranch)).to((Ref)(branch == null ? fromBranch : branch))).type(RefChangeType.UPDATE)).build();
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }
}

