/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.SimpleCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitRebaseCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.repository.sync.RefResolver;
import com.atlassian.stash.internal.repository.sync.SimpleRejectedRef;
import com.atlassian.stash.internal.repository.sync.command.RebaseRefCommandParameters;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebaseRefCommand
extends SimpleCommand<RefChange> {
    private static final Logger log = LoggerFactory.getLogger(RebaseRefCommand.class);
    private final GitExtendedCommandFactory commandFactory;
    private final I18nService i18nService;
    private final String refId;
    private final RefResolver refResolver;
    private final Repository repository;
    private final Repository upstream;
    private final ApplicationUser user;
    private long executionTimeout;
    private long idleTimeout;

    public RebaseRefCommand(GitExtendedCommandFactory commandFactory, I18nService i18nService, RefResolver refResolver, RebaseRefCommandParameters parameters) {
        this.commandFactory = commandFactory;
        this.i18nService = i18nService;
        this.refResolver = refResolver;
        this.refId = parameters.getRefId();
        this.repository = parameters.getRepository();
        this.upstream = parameters.getUpstream();
        this.user = parameters.getUser();
    }

    public RefChange call() {
        if (SimpleRejectedRef.isTag(this.refId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.rebase.tag", new Object[0]));
        }
        Branch branch = this.refResolver.resolveBranch(this.repository, this.refId);
        if (branch == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.rebase.nosuchbranch", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.refId});
            throw new NoSuchCommitException(message, this.refId);
        }
        Branch upstreamBranch = this.refResolver.resolveBranch(this.upstream, this.refId);
        if (upstreamBranch == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.refsync.rebase.nothingupstream", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.refId, this.upstream.getProject().getKey(), this.upstream.getSlug()});
            throw new NoSuchCommitException(message, this.refId);
        }
        if (StringUtils.equals((CharSequence)upstreamBranch.getLatestCommit(), (CharSequence)branch.getLatestCommit())) {
            log.debug("{}/{}:{} is already in sync with {}/{} ({})", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.refId, this.upstream.getProject().getKey(), this.upstream.getSlug(), branch.getLatestCommit()});
            return null;
        }
        GitCommand command = this.commandFactory.rebase(this.repository, new GitRebaseCommandParameters.Builder(branch, upstreamBranch.getLatestCommit()).committer(this.user).upstreamRepository(this.upstream).build());
        command.setExecutionTimeout(this.executionTimeout);
        command.setIdleTimeout(this.idleTimeout);
        Branch rebased = (Branch)command.call();
        return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().fromHash(branch.getLatestCommit())).to((Ref)(rebased == null ? upstreamBranch : rebased))).type(RefChangeType.UPDATE)).build();
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }
}

