/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.repository.sync.RefSyncResult;
import com.atlassian.stash.internal.repository.sync.SimpleRefSyncStatus;
import com.atlassian.stash.internal.repository.sync.SimpleRejectedRef;
import com.atlassian.stash.internal.repository.sync.dao.AoRefSyncConfig;
import com.atlassian.stash.internal.repository.sync.dao.AoRejectedRef;
import com.atlassian.stash.internal.repository.sync.dao.RefSyncDao;
import com.atlassian.stash.internal.repository.sync.dao.RefSyncNotConfiguredException;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class AoRefSyncDao
extends AbstractAoDao
implements RefSyncDao {
    private static final String REPOSITORY_QUERY = "REPOSITORY_ID = ?";
    private static final String REPOSITORY_AND_REF_QUERY = "REPOSITORY_ID = ? AND REF_ID = ?";

    public AoRefSyncDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public void cleanup(int repositoryId) {
        AoRefSyncConfig config = this.findConfig(repositoryId);
        if (config != null) {
            this.ao.delete(new RawEntity[]{config});
        }
        this.removeRefs(repositoryId);
    }

    @Override
    public RejectedRef getRef(int repositoryId, @Nonnull String refId) {
        AoRejectedRef ref = this.findRef(repositoryId, refId);
        return ref == null ? null : new SimpleRejectedRef.Builder(ref).build();
    }

    @Override
    @Nonnull
    public Page<RejectedRef> getRefs(int repositoryId, @Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoRejectedRef.class, Query.select().where(REPOSITORY_QUERY, new Object[]{repositoryId}).order("REF_ID ASC"), pageRequest).transform(aoRejectedRef -> new SimpleRejectedRef.Builder((AoRejectedRef)aoRejectedRef).build());
    }

    @Override
    public RefSyncStatus getStatus(int repositoryId) {
        AoRefSyncConfig config = this.findConfig(repositoryId);
        if (config == null) {
            return null;
        }
        SimpleRefSyncStatus.Builder builder = new SimpleRefSyncStatus.Builder(config);
        for (AoRejectedRef ref : this.findRefsByRepository(repositoryId)) {
            builder.rejectedRef(new SimpleRejectedRef.Builder(ref).build());
        }
        return builder.build();
    }

    @Override
    public boolean isEnabled(int repositoryId) {
        AoRefSyncConfig config = this.findConfig(repositoryId);
        return config != null && config.isEnabled();
    }

    @Override
    public int removeRef(int repositoryId, @Nonnull String refId) {
        return this.ao.deleteWithSQL(AoRejectedRef.class, REPOSITORY_AND_REF_QUERY, new Object[]{repositoryId, refId});
    }

    @Override
    public void setEnabled(int repositoryId, boolean enabled) {
        AoRefSyncConfig config = this.findConfig(repositoryId);
        if (config == null) {
            if (enabled) {
                this.ao.create(AoRefSyncConfig.class, (Map)ImmutableMap.of((Object)"IS_ENABLED", (Object)true, (Object)"LAST_SYNC", (Object)new Date(), (Object)"REPOSITORY_ID", (Object)repositoryId));
            }
        } else if (config.isEnabled() != enabled) {
            config.setEnabled(enabled);
            config.save();
            if (!enabled) {
                this.removeRefs(repositoryId);
            }
        }
    }

    @Override
    public void setRejectedRefs(int repositoryId, @Nonnull Stream<RejectedRef> rejectedRefs) {
        this.removeRefs(repositoryId);
        rejectedRefs.forEach(rejectedRef -> this.createAoRejectedRef(repositoryId, (RejectedRef)rejectedRef));
    }

    @Override
    public void setStatus(int repositoryId, @Nonnull RefSyncResult result) {
        AoRefSyncConfig config = this.findConfig(repositoryId);
        if (config == null) {
            throw new RefSyncNotConfiguredException(repositoryId);
        }
        if (result.isSynchronized()) {
            config.setLastSync(new Date());
            config.save();
        }
        for (RefChange changedRef : result.getChangedRefs()) {
            this.removeRef(repositoryId, changedRef.getRef().getId());
        }
        for (RejectedRef rejectedRef : result.getRejectedRefs()) {
            AoRejectedRef ref = this.findRef(repositoryId, rejectedRef.getId());
            if (ref == null) {
                this.createAoRejectedRef(repositoryId, rejectedRef);
                continue;
            }
            if (ref.getState() == rejectedRef.getState().getId()) continue;
            ref.setState(rejectedRef.getState().getId());
            ref.save();
        }
    }

    @Override
    public boolean updateRef(int repositoryId, @Nonnull String refId, @Nonnull RejectedRefState state) {
        AoRejectedRef ref = this.findRef(repositoryId, refId);
        if (ref == null || ref.getState() == state.getId()) {
            return false;
        }
        ref.setState(state.getId());
        ref.save();
        return true;
    }

    private void createAoRejectedRef(int repositoryId, RejectedRef rejectedRef) {
        this.ao.create(AoRejectedRef.class, (Map)ImmutableMap.of((Object)"REF_DISPLAY_ID", (Object)rejectedRef.getDisplayId(), (Object)"REF_ID", (Object)rejectedRef.getId(), (Object)"REPOSITORY_ID", (Object)repositoryId, (Object)"REF_STATUS", (Object)rejectedRef.getState().getId()));
    }

    private AoRefSyncConfig findConfig(Integer repositoryId) {
        return (AoRefSyncConfig)this.ao.get(AoRefSyncConfig.class, (Object)repositoryId);
    }

    private AoRejectedRef findRef(Integer repositoryId, String refId) {
        AoRejectedRef[] refs = this.findRefsById(repositoryId, refId);
        if (refs.length == 0) {
            return null;
        }
        for (int i = 1; i < refs.length; ++i) {
            this.ao.delete(new RawEntity[]{refs[i]});
        }
        return refs[0];
    }

    private AoRejectedRef[] findRefsById(Integer repositoryId, String refId) {
        return (AoRejectedRef[])this.ao.find(AoRejectedRef.class, REPOSITORY_AND_REF_QUERY, new Object[]{repositoryId, refId});
    }

    private AoRejectedRef[] findRefsByRepository(Integer repositoryId) {
        return (AoRejectedRef[])this.ao.find(AoRejectedRef.class, REPOSITORY_QUERY, new Object[]{repositoryId});
    }

    private void removeRefs(Integer repositoryId) {
        this.ao.deleteWithSQL(AoRejectedRef.class, REPOSITORY_QUERY, new Object[]{repositoryId});
    }
}

