/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.migration;

import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.stash.internal.repository.sync.SimpleRejectedRef;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class MigrationRejectedRef {
    @JsonProperty
    private String displayId;
    @JsonProperty
    private String id;
    @JsonProperty
    private int state;

    @JsonCreator
    public MigrationRejectedRef(@JsonProperty(value="displayId") String displayId, @JsonProperty(value="id") String id, @JsonProperty(value="state") int state) {
        this.displayId = Objects.requireNonNull(displayId, "displayId");
        this.id = Objects.requireNonNull(id, "id");
        this.state = state;
    }

    public MigrationRejectedRef(@Nonnull RejectedRef rejectedRef) {
        this.displayId = rejectedRef.getDisplayId();
        this.id = rejectedRef.getId();
        this.state = rejectedRef.getState().getId();
    }

    public RejectedRef asRejectedRef() {
        return ((SimpleRejectedRef.Builder)((SimpleRejectedRef.Builder)new SimpleRejectedRef.Builder().state(RejectedRefState.fromId((int)this.state)).type((RefType)(SimpleRejectedRef.isTag(this.id) ? StandardRefType.TAG : StandardRefType.BRANCH)).id(this.id)).displayId(this.displayId)).build();
    }
}

