/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.migration;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.repository.sync.InternalRefSyncService;
import com.atlassian.stash.internal.repository.sync.migration.MigrationRejectedRef;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.annotation.Nonnull;
import java.nio.file.Paths;
import java.util.Objects;

public class RefSyncStatusExporter
implements Exporter {
    private static final JsonFactory JSON_FACTORY = new ObjectMapper().disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE).getJsonFactory();
    private static final int REJECTED_REFS_BATCH_SIZE = 100;
    private final InternalRefSyncService refSyncService;

    public RefSyncStatusExporter(InternalRefSyncService refSyncService) {
        this.refSyncService = refSyncService;
    }

    public void export(@Nonnull ExportContext context, @Nonnull Repository repository) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(repository, "repository");
        String repositoryId = context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)repository.getId());
        if (this.refSyncService.isEnabled(repository)) {
            context.addEntry(Paths.get(repositoryId, "rejected-refs.json"), outputStream -> {
                try (JsonGenerator generator = JSON_FACTORY.createJsonGenerator(outputStream);){
                    generator.writeStartArray();
                    for (MigrationRejectedRef ref : this.getRejectedRefs(repository)) {
                        generator.writeObject((Object)ref);
                    }
                    generator.writeEndArray();
                }
            }, true);
        }
    }

    @Nonnull
    private Iterable<MigrationRejectedRef> getRejectedRefs(@Nonnull Repository repository) {
        return () -> PageUtils.toStream(request -> this.refSyncService.getRejectedRefs(repository, request), (int)100).map(MigrationRejectedRef::new).iterator();
    }
}

