/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.stash.internal.repository.sync.InternalRefSyncService;
import com.atlassian.stash.internal.repository.sync.migration.MigrationRejectedRef;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefSyncStatusImporter
implements Importer {
    private static final JsonFactory JSON_FACTORY = new ObjectMapper().getFactory();
    private static final String PATH_SEP = File.separatorChar == '\\' ? "\\\\" : File.separator;
    private static final PathMatcher REJECTED_REFS_MATCHER = FileSystems.getDefault().getPathMatcher("glob:*/rejected-refs.json".replace("/", PATH_SEP));
    private static final Logger log = LoggerFactory.getLogger(RefSyncStatusImporter.class);
    private final I18nService i18nService;
    private final InternalRefSyncService refSyncService;
    private final RepositoryService repositoryService;

    public RefSyncStatusImporter(I18nService i18nService, InternalRefSyncService refSyncService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.refSyncService = refSyncService;
        this.repositoryService = repositoryService;
    }

    public void onEntry(@Nonnull ImportContext context, @Nonnull EntrySource entry) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(entry, "entry");
        Path path = entry.getPath();
        log.debug("Importing ref sync status from path: {}", (Object)path);
        try {
            if (REJECTED_REFS_MATCHER.matches(path)) {
                entry.read(inputStream -> this.importRejectedRefs(this.resolveRepositoryOrFail(context, RefSyncStatusImporter.resolveExportId(path)), (InputStream)inputStream));
            } else {
                context.addWarning(this.i18nService.createKeyedMessage("bitbucket.refsync.migration.import.unknown.entry", new Object[]{path}), null);
            }
        }
        catch (IOException e) {
            throw this.newImportException(path, e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw this.newImportException(path, (IOException)e.getCause());
            }
            throw e;
        }
    }

    private static void ensureNextTokenIs(@Nonnull JsonParser jsonParser, @Nonnull JsonToken expectedToken) throws IOException {
        JsonToken token = jsonParser.nextToken();
        if (token != expectedToken) {
            throw new JsonParseException("Unexpected " + String.valueOf(token) + ", expected " + String.valueOf(expectedToken), jsonParser.getTokenLocation());
        }
    }

    @Nonnull
    private static String resolveExportId(@Nonnull Path path) {
        return path.getName(0).toString();
    }

    private void importRejectedRefs(@Nonnull Repository repository, @Nonnull InputStream inputStream) throws IOException {
        try (JsonParser jsonParser = JSON_FACTORY.createParser(inputStream);){
            RefSyncStatusImporter.ensureNextTokenIs(jsonParser, JsonToken.START_ARRAY);
            jsonParser.nextToken();
            Iterator it = jsonParser.readValuesAs(MigrationRejectedRef.class);
            Stream<RejectedRef> rejectedRefs = MoreStreams.streamIterable(() -> it).map(MigrationRejectedRef::asRejectedRef);
            this.refSyncService.importRefSync(repository, rejectedRefs);
        }
    }

    @Nonnull
    private ImportException newImportException(@Nonnull Path path, @Nonnull Exception cause) {
        return new ImportException(this.i18nService.createKeyedMessage("bitbucket.refsync.migration.import.failed", new Object[]{path}), (Throwable)cause);
    }

    @Nonnull
    private Repository resolveRepositoryOrFail(@Nonnull ImportContext context, @Nonnull String exportId) {
        return context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(exportId).map(arg_0 -> ((RepositoryService)this.repositoryService).getById(arg_0)).orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.refsync.migration.import.repository.notfound", new Object[]{exportId})));
    }
}

