/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RefSyncRequest;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.repository.sync.InternalRefSyncService;
import com.atlassian.stash.internal.repository.sync.rest.RestRefSyncRequest;
import com.atlassian.stash.internal.repository.sync.rest.RestRefSyncStatus;
import com.atlassian.stash.internal.repository.sync.rest.RestRejectedRef;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RefSyncResource {
    private final I18nService i18nService;
    private final InternalRefSyncService syncService;

    @Inject
    public RefSyncResource(I18nService i18nService, InternalRefSyncService syncService) {
        this.i18nService = i18nService;
        this.syncService = syncService;
    }

    @Operation(description="Retrieves the synchronization status for the specified repository. In addition to listing refs which cannot be synchronized, if any, the status also provides the timestamp for the most recent synchronization and indicates whether synchronization is available and enabled. If \"?at\" is specified in the URL, the synchronization status for the specified ref is returned, rather than the complete repository status.\n\nThe authenticated user must have <b>REPO_READ</b> permission for the repository, or it must be public if the request is anonymous. Additionally, after synchronization is enabled for a repository, meaning synchronization was available at that time, permission changes and other actions can cause it to become unavailable. Even when synchronization is enabled, if it is no longer available for the repository it will not be performed.", summary="Get synchronization status")
    @Parameter(description="Retrieves the synchronization status for the specified ref within the repository, rather than for the entire repository", in=ParameterIn.QUERY, name="at")
    @ResponseDocs(value={@ResponseDoc(documentation="Synchronization status for the specified repository, or specific ref within that repository.", representation=RestRefSyncStatus.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository, or the repository is not public if the request is anonymous.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getStatus(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="at") String refId) {
        if (StringUtils.isNotBlank((CharSequence)refId)) {
            return this.getRefStatus(repositoryResolver.getRepository(), refId);
        }
        return this.getRepositoryStatus(repositoryResolver.getRepository());
    }

    @Operation(description="Enables or disables synchronization for the specified repository. When synchronization is enabled, branches within the repository are immediately synchronized and the status is updated with the outcome. That initial synchronization is performed before the REST request returns, allowing it to return the updated status.\n\nThe authenticated user must have <b>REPO_ADMIN</b> permission for the specified repository. Anonymous users cannot manage synchronization, even on public repositories. Additionally, synchronization must be available for the specified repository. Synchronization is only available if:\n\n- The repository is a fork, since its origin is used as upstream\n- The owning user still has access to the fork's origin,  if the repository is a <i>personalfork</i>", summary="Disable synchronization")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestRefSyncStatus.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The updated synchronization status for the repository, after enabling synchronization. 204 NO CONTENT is returned instead after disabling synchronization.", representation=RestRefSyncStatus.class, responseCode=200), @ResponseDoc(documentation="Synchronization has successfully been disabled. 200 OK, with updated status information, is returned instead after enabling synchronization.", responseCode=204), @ResponseDoc(documentation="The JSON payload for the request did not define the \"enabled\" property.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to manage synchronization in the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setEnabled(@BeanParam RepositoryResolver repositoryResolver, RestRefSyncStatus restStatus) {
        if (restStatus.containsKey("enabled")) {
            boolean enabled = restStatus.isEnabled();
            this.syncService.setEnabled(repositoryResolver.getRepository(), enabled);
            return this.getRepositoryStatus(repositoryResolver.getRepository());
        }
        throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.refsync.enablenotprovided", new Object[]{"enabled"}));
    }

    @Operation(description="Allows developers to apply a manual operation to bring a ref back in sync with upstream when it becomes out of sync due to conflicting changes. The following actions are supported:\n\n- <tt>MERGE</tt>: Merges in commits from the upstream ref. After applying this action, the   synchronized ref will be <tt>AHEAD</tt> (as it still includes commits that do not exist   upstream.\n   - This action is only supported for <tt>DIVERGED</tt> refs\n   - If a \"commitMessage\" is provided in the context, it will be used on the merge commit.      Otherwise a default message is used.\n- <tt>DISCARD</tt>: <i>Throws away</i> local changes in favour of those made upstream. This is a   <i>destructive</i> operation where commits in the local repository are lost.\n   - No context entries are supported for this action\n   - If the upstream ref has been deleted, the local ref is deleted as well\n   - Otherwise, the local ref is updated to reference the same commit as upstream, even if      the update is not fast-forward (similar to a forced push)\n\n\nThe authenticated user must have <b>REPO_WRITE</b> permission for the specified repository. Anonymous users cannot synchronize refs, even on public repositories. Additionally, synchronization must be <i>enabled</i> and <i>available</i> for the specified repository.", summary="Manual synchronization")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestRefSyncRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested action was successfully performed, and has updated the ref's state, but the ref if is still not in sync with upstream. For example, after applying the <tt>MERGE</tt> action, the ref will still be <tt>AHEAD</tt> of upstream. If the action brings the ref in sync with upstream, 204 NO CONTENT is returned instead.", representation=RestRejectedRef.class, responseCode=200), @ResponseDoc(documentation="The requested action was successfully performed and the ref is now in sync with upstream. If the action updates the ref but does not bring it in sync with upstream, 200 OK is returned instead.", responseCode=204), @ResponseDoc(documentation="The requested synchronization action was not understood.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update refs within the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Synchronization is not available or enabled for the specified repository, or the ref is already in sync with upstream.", responseCode=409, restError=true), @ResponseDoc(documentation="The requested synchronization action was understood by the server, but the mechanism to apply it has not been implemented.", responseCode=501, restError=true)})
    @POST
    @Path(value="/synchronize")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response synchronize(@BeanParam RepositoryResolver repositoryResolver, RestRefSyncRequest restSyncRequest) {
        String refId = restSyncRequest.getRefId();
        this.syncService.synchronize(new RefSyncRequest.Builder().action(restSyncRequest.getAction()).context(restSyncRequest.getContext()).refId(refId).repository(repositoryResolver.getRepository()).build());
        return this.getRefStatus(repositoryResolver.getRepository(), refId);
    }

    private Response getRefStatus(Repository repository, String refId) {
        RejectedRef status = this.syncService.getStatus(repository, refId);
        if (status == null) {
            return ResponseFactory.noContent().build();
        }
        return ResponseFactory.ok((Object)((Object)new RestRejectedRef(status))).build();
    }

    private Response getRepositoryStatus(Repository repository) {
        RefSyncStatus status = this.syncService.getStatus(repository);
        RestRefSyncStatus restStatus = status == null ? new RestRefSyncStatus(this.syncService.isAvailable(repository)) : new RestRefSyncStatus(status);
        return ResponseFactory.ok((Object)((Object)restStatus)).build();
    }
}

