/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.rest;

import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.stash.internal.repository.sync.rest.RestRejectedRef;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

@JsonSerialize
@JsonSurrogate(value=RefSyncStatus.class)
public class RestRefSyncStatus
extends RestMapEntity {
    public static final String ENABLED = "enabled";
    private static final String AHEAD_REFS = "aheadRefs";
    private static final String AVAILABLE = "available";
    private static final String DIVERGED_REFS = "divergedRefs";
    private static final String LAST_SYNC = "lastSync";
    private static final String ORPHANED_REFS = "orphanedRefs";

    public RestRefSyncStatus() {
    }

    public RestRefSyncStatus(boolean available) {
        this.put(AVAILABLE, available);
        this.put(ENABLED, false);
    }

    public RestRefSyncStatus(RefSyncStatus status) {
        this.put(AVAILABLE, status.isAvailable());
        this.put(ENABLED, status.isEnabled());
        this.put(LAST_SYNC, status.getLastSync());
        if (status.isEnabled()) {
            this.putRefs(AHEAD_REFS, status.getAheadRefs());
            this.putRefs(DIVERGED_REFS, status.getDivergedRefs());
            this.putRefs(ORPHANED_REFS, status.getOrphanedRefs());
        }
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isAvailable() {
        return this.getBoolProperty(AVAILABLE);
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED, true);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestRejectedRef getAheadRefs() {
        return (RestRejectedRef)((Object)this.get(AHEAD_REFS));
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestRejectedRef getDivergedRefs() {
        return (RestRejectedRef)((Object)this.get(DIVERGED_REFS));
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY, example="1331038800000", type="number")
    public Date getLastSync() {
        return (Date)this.get(LAST_SYNC);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestRejectedRef getOrphanedRefs() {
        return (RestRejectedRef)((Object)this.get(ORPHANED_REFS));
    }

    private void putRefs(String key, Set<RejectedRef> refs) {
        this.put(key, ImmutableList.copyOf((Collection)Collections2.transform(refs, RestRejectedRef.REST_TRANSFORM)));
    }
}

