/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.server.internal.suggestreviewers.MergeBaseResolver;
import com.atlassian.bitbucket.server.internal.suggestreviewers.SimpleSuggestedReviewer;
import com.atlassian.bitbucket.server.internal.suggestreviewers.SuggestedReviewerMetadataProvider;
import com.atlassian.bitbucket.server.internal.suggestreviewers.UserRanking;
import com.atlassian.bitbucket.server.suggestreviewers.PullRequestDetails;
import com.atlassian.bitbucket.server.suggestreviewers.SuggestedReviewer;
import com.atlassian.bitbucket.server.suggestreviewers.SuggestedReviewerService;
import com.atlassian.bitbucket.server.suggestreviewers.spi.Reason;
import com.atlassian.bitbucket.server.suggestreviewers.spi.ReviewerSuggester;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.PluginAccessor;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoringSuggestedReviewerService
implements SuggestedReviewerService {
    private static final Logger log = LoggerFactory.getLogger(ScoringSuggestedReviewerService.class);
    private final AuthenticationContext authenticationContext;
    private final CommitService commitService;
    private final FeatureManager featureManager;
    private final MergeBaseResolver mergeBaseResolver;
    private final PermissionService permissionService;
    private final PluginAccessor pluginAccessor;
    private final SuggestedReviewerMetadataProvider reviewerMetadataProvider;

    public ScoringSuggestedReviewerService(AuthenticationContext authenticationContext, CommitService commitService, FeatureManager featureManager, MergeBaseResolver mergeBaseResolver, PermissionService permissionService, PluginAccessor pluginAccessor, SuggestedReviewerMetadataProvider reviewerMetadataProvider) {
        this.authenticationContext = authenticationContext;
        this.commitService = commitService;
        this.featureManager = featureManager;
        this.mergeBaseResolver = mergeBaseResolver;
        this.permissionService = permissionService;
        this.pluginAccessor = pluginAccessor;
        this.reviewerMetadataProvider = reviewerMetadataProvider;
    }

    @Override
    @Nonnull
    public Iterable<SuggestedReviewer> getSuggestedReviewers(@Nonnull PullRequestDetails details, int limit) {
        this.featureManager.requireEnabled((Feature)StandardFeature.SUGGEST_REVIEWERS);
        Objects.requireNonNull(details, "details");
        Repository fromRepo = details.getFromCommit().getRepository();
        Repository toRepo = details.getToCommit().getRepository();
        if (fromRepo == null || toRepo == null) {
            return Collections.emptyList();
        }
        if (this.isAlreadyMerged(toRepo, details.getToCommit(), fromRepo, details.getFromCommit())) {
            return Collections.emptyList();
        }
        PullRequestDetails pullRequestDetails = this.ensureValidDetails(details);
        UserRanking ranking = new UserRanking();
        this.pluginAccessor.getEnabledModulesByClass(ReviewerSuggester.class).stream().map(suggester -> ScoringSuggestedReviewerService.maybeGetSuggestions(suggester, pullRequestDetails)).filter(Objects::nonNull).filter(map -> !map.isEmpty()).map(Map::entrySet).flatMap(Collection::stream).filter(entry -> entry.getKey() != null && entry.getValue() != null && !((Collection)entry.getValue()).isEmpty()).forEach(entry -> ranking.addRanking((ApplicationUser)entry.getKey(), (Collection)entry.getValue()));
        return this.toSuggestedReviewers(this.authenticationContext.getCurrentUser(), fromRepo, ranking, limit);
    }

    List<SuggestedReviewer> toSuggestedReviewers(ApplicationUser currentUser, Repository repository, UserRanking ranking, int limit) {
        return ranking.getSortedRankedUserStream().filter(rankedUser -> currentUser == null || !ApplicationUserEquality.equals((ApplicationUser)currentUser, (Object)rankedUser.getUser())).filter(rankedUser -> this.permissionService.hasGlobalPermission(rankedUser.getUser(), Permission.LICENSED_USER)).filter(rankedUser -> this.permissionService.hasRepositoryPermission(rankedUser.getUser(), repository, Permission.REPO_READ)).limit(limit).map(rankedUser -> {
            ApplicationUser user = rankedUser.getUser();
            return new SimpleSuggestedReviewer(user, ranking.getMostRelevantReason(user).getShortDescription(), ranking.getAllReasons(user).stream().map(Reason::getDescription).collect(Collectors.toList()), this.reviewerMetadataProvider.getTotalReviewingCount(user));
        }).collect(Collectors.toList());
    }

    private static Map<ApplicationUser, Collection<Reason>> maybeGetSuggestions(ReviewerSuggester suggester, PullRequestDetails details) {
        try {
            return suggester.suggestFor(details);
        }
        catch (Exception e) {
            log.error("{} threw an exception (or returned unexpected data) when suggesting reviewers and was ignored.", suggester.getClass(), (Object)e);
            return null;
        }
    }

    private PullRequestDetails ensureValidDetails(PullRequestDetails details) {
        if (details.getMergeBase() == null) {
            Commit mergeBase = this.mergeBaseResolver.findMergeBase(details.getFromCommit(), details.getToCommit());
            return new PullRequestDetails.Builder().fromCommit(details.getFromCommit()).toCommit(details.getToCommit()).fromRefId(details.getFromRefId()).toRefId(details.getFromRefId()).mergeBase(mergeBase).build();
        }
        return details;
    }

    private boolean isAlreadyMerged(Repository toRepo, Commit since, Repository fromRepo, Commit until) {
        CommitsBetweenRequest request = new CommitsBetweenRequest.Builder(toRepo).include(until.getId(), new String[0]).exclude(since.getId(), new String[0]).secondaryRepository(fromRepo).build();
        return this.commitService.getCommitsBetween(request, PageUtils.newRequest((int)0, (int)1)).getSize() == 0;
    }
}

