/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers;

import com.atlassian.bitbucket.server.internal.suggestreviewers.RankedUser;
import com.atlassian.bitbucket.server.suggestreviewers.spi.Reason;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class UserRanking {
    private final Map<ApplicationUser, Reason> mostRelevantReason;
    private final Map<ApplicationUser, RankedUser> rankings;
    private final Multimap<ApplicationUser, Reason> reasons = HashMultimap.create();

    public UserRanking() {
        this.mostRelevantReason = new HashMap<ApplicationUser, Reason>();
        this.rankings = new HashMap<ApplicationUser, RankedUser>();
    }

    public void addRanking(ApplicationUser user, Collection<Reason> reasons) {
        RankedUser ranking = this.rankings.get(user);
        if (ranking == null) {
            ranking = new RankedUser(user);
            this.rankings.put(user, ranking);
        }
        Reason best = this.mostRelevantReason.get(user);
        for (Reason reason : reasons) {
            this.reasons.put((Object)user, (Object)reason);
            ranking.add(reason.getScore());
            if (best != null && reason.getScore() <= best.getScore()) continue;
            best = reason;
        }
        this.mostRelevantReason.put(user, best);
    }

    public Collection<Reason> getAllReasons(ApplicationUser user) {
        return this.reasons.get((Object)user);
    }

    public Reason getMostRelevantReason(ApplicationUser user) {
        return this.mostRelevantReason.get(user);
    }

    public Stream<RankedUser> getSortedRankedUserStream() {
        return this.rankings.values().stream().sorted();
    }
}

