/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.server.internal.suggestreviewers.rest.RestSuggestedReviewer;
import com.atlassian.bitbucket.server.suggestreviewers.PullRequestDetails;
import com.atlassian.bitbucket.server.suggestreviewers.SuggestedReviewer;
import com.atlassian.bitbucket.server.suggestreviewers.SuggestedReviewerService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="by")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class SuggestedReviewersResource {
    private final CommitService commitService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final SuggestedReviewerService suggestedReviewerService;

    @Inject
    public SuggestedReviewersResource(CommitService commitService, FeatureManager featureManager, I18nService i18nService, RefService refService, RepositoryService repositoryService, SuggestedReviewerService suggestedReviewerService) {
        this.commitService = commitService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.suggestedReviewerService = suggestedReviewerService;
    }

    @GET
    @Path(value="ref")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response forRefs(@QueryParam(value="fromRepoId") Integer fromRepoId, @QueryParam(value="from") String fromRef, @QueryParam(value="toRepoId") Integer toRepoId, @QueryParam(value="to") String toRef, @QueryParam(value="count") @DefaultValue(value="5") int count) {
        this.featureManager.requireEnabled((Feature)StandardFeature.SUGGEST_REVIEWERS);
        this.checkParams(fromRepoId, fromRef, toRepoId, toRef);
        Commit toHead = this.getLatestCommit(this.requireRepository(toRepoId), toRef);
        Commit fromHead = this.getLatestCommit(this.requireRepository(fromRepoId), fromRef);
        PullRequestDetails details = new PullRequestDetails.Builder().fromCommit(fromHead).toCommit(toHead).fromRefId(fromRef).toRefId(toRef).build();
        return this.suggestReviewers(details, count);
    }

    @GET
    @Path(value="sha")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response forShas(@QueryParam(value="fromRepoId") Integer fromRepoId, @QueryParam(value="from") String fromSha, @QueryParam(value="toRepoId") Integer toRepoId, @QueryParam(value="to") String toSha, @QueryParam(value="count") @DefaultValue(value="5") int count) {
        this.featureManager.requireEnabled((Feature)StandardFeature.SUGGEST_REVIEWERS);
        this.checkParams(fromRepoId, fromSha, toRepoId, toSha);
        Commit toHead = this.commitService.getCommit(new CommitRequest.Builder(this.requireRepository(toRepoId), toSha).build());
        Commit fromHead = this.commitService.getCommit(new CommitRequest.Builder(this.requireRepository(fromRepoId), fromSha).build());
        return this.suggestReviewers(new PullRequestDetails.Builder().fromCommit(fromHead).toCommit(toHead).build(), count);
    }

    private void checkParams(Integer fromRepoId, String from, Integer toRepoId, String to) {
        if (fromRepoId == null || StringUtils.isBlank((CharSequence)from) || toRepoId == null || StringUtils.isBlank((CharSequence)to)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.suggestedreviewers.params.required", new Object[0]));
        }
    }

    private Commit getLatestCommit(Repository repository, String refName) {
        ResolveRefRequest request = new ResolveRefRequest.Builder(repository).refId(refName).build();
        Ref ref = this.refService.resolveRef(request);
        if (ref == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.suggestedreviewers.no.such.ref", new Object[]{refName});
            throw new NoSuchEntityException(message);
        }
        return this.commitService.getCommit(new CommitRequest.Builder(repository, ref.getLatestCommit()).build());
    }

    private Repository requireRepository(int fromRepoId) {
        Repository repository = this.repositoryService.getById(fromRepoId);
        if (repository == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.suggestedreviewers.no.such.repository", new Object[]{fromRepoId});
            throw new NoSuchRepositoryException(message, null);
        }
        return repository;
    }

    private Response suggestReviewers(PullRequestDetails details, int count) {
        Iterable<SuggestedReviewer> reviewers = this.suggestedReviewerService.getSuggestedReviewers(details, count);
        Iterable restReviewers = MoreStreams.streamIterable(reviewers).map(RestSuggestedReviewer::new).collect(Collectors.toList());
        return ResponseFactory.ok((Object)restReviewers).build();
    }
}

