/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers.rest;

import com.atlassian.bitbucket.server.suggestreviewers.spi.UserResolver;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Objects;

public class UserServiceUserResolver
implements UserResolver {
    private final UserService userService;

    public UserServiceUserResolver(UserService userService) {
        this.userService = userService;
    }

    @Override
    @Nonnull
    public Iterable<ApplicationUser> resolve(@Nonnull Iterable<String> emailAddresses) {
        Objects.requireNonNull(emailAddresses, "emailAddresses");
        ArrayList<ApplicationUser> resolvedUsers = new ArrayList<ApplicationUser>();
        for (String email : emailAddresses) {
            ApplicationUser user = this.resolve(email);
            if (user == null) continue;
            resolvedUsers.add(user);
        }
        return resolvedUsers;
    }

    @Override
    public ApplicationUser resolve(@Nonnull String emailAddress) {
        Objects.requireNonNull(emailAddress, "emailAddress");
        return this.userService.findUserByNameOrEmail(emailAddress);
    }
}

