/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers.suggester;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import com.atlassian.bitbucket.scm.git.command.blame.GitBlameBuilder;
import com.atlassian.bitbucket.server.internal.suggestreviewers.SuggestionCommandBuilderFactory;
import com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git.BlameAttributionOutputHandler;
import com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git.DiffNumstatOutputHandler;
import com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git.DiffSummary;
import com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git.DiffSummaryOutputHandler;
import com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git.MissingPathIgnoringExitHandler;
import com.atlassian.bitbucket.server.internal.suggestreviewers.util.StringUtils;
import com.atlassian.bitbucket.server.suggestreviewers.PullRequestDetails;
import com.atlassian.bitbucket.server.suggestreviewers.spi.Reason;
import com.atlassian.bitbucket.server.suggestreviewers.spi.ReviewerSuggester;
import com.atlassian.bitbucket.server.suggestreviewers.spi.SimpleReason;
import com.atlassian.bitbucket.server.suggestreviewers.spi.UserResolver;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BlameSuggester
implements ReviewerSuggester {
    private static final int MAX_FILES_CONSIDERED = 5;
    private static final int MAX_SCORE_PER_FILE = 100;
    private final SuggestionCommandBuilderFactory builderFactory;
    private final I18nService i18nService;
    private final UserResolver userResolver;

    public BlameSuggester(SuggestionCommandBuilderFactory builderFactory, UserResolver userResolver, I18nService i18nService) {
        this.builderFactory = builderFactory;
        this.userResolver = userResolver;
        this.i18nService = i18nService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<ApplicationUser, Collection<Reason>> suggestFor(@Nonnull PullRequestDetails pullRequestDetails) {
        Objects.requireNonNull(pullRequestDetails, "pullRequestDetails");
        Commit since = pullRequestDetails.getMergeBase();
        Commit until = pullRequestDetails.getFromCommit();
        if (since == null) {
            return Collections.emptyMap();
        }
        HashMultimap suggestions = HashMultimap.create();
        try {
            DiffSummary diffSummary = this.getDiffSummary(since, until);
            HashMap<String, ApplicationUser> usersByEmail = new HashMap<String, ApplicationUser>();
            Iterator<Map.Entry<String, Pair<Integer, Integer>>> iterator = this.getPathDeltas(since, until).iterator();
            for (int i = 0; i < 5; ++i) {
                if (iterator.hasNext()) {
                    Map.Entry<String, Pair<Integer, Integer>> delta = iterator.next();
                    String path = delta.getKey();
                    if (diffSummary.getCreatedPaths().contains(path)) {
                        --i;
                        continue;
                    }
                    Set<Map.Entry<ApplicationUser, Integer>> entries = this.getBlame(until.getRepository(), since.getRepository(), path, since.getId(), usersByEmail).entrySet();
                    if (entries.isEmpty()) {
                        --i;
                        continue;
                    }
                    for (Map.Entry<ApplicationUser, Integer> author : entries) {
                        boolean added = (Integer)delta.getValue().left() > (Integer)delta.getValue().right();
                        int locDelta = added ? (Integer)delta.getValue().left() : (Integer)delta.getValue().right();
                        int authorBlame = author.getValue();
                        if (diffSummary.getDeletedPaths().contains(path)) {
                            suggestions.put((Object)author.getKey(), (Object)new SimpleReason("Previously contributed to files that were deleted.", String.format("Authored %s %s of %s, which was deleted.", authorBlame, StringUtils.pluralize(authorBlame, "line", "lines"), BlameSuggester.lastSegment(path)), authorBlame * locDelta));
                            continue;
                        }
                        suggestions.put((Object)author.getKey(), (Object)new SimpleReason("Previously contributed to files that were modified.", String.format("Authored %s %s of %s, which had %s %s %s %s it.", authorBlame, StringUtils.pluralize(authorBlame, "line", "lines"), BlameSuggester.lastSegment(path), locDelta, StringUtils.pluralize(locDelta, "line", "lines"), added ? "added" : "removed", added ? "to" : "from"), authorBlame * locDelta));
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            return BlameSuggester.scaleScores((Multimap<ApplicationUser, SimpleReason>)suggestions).asMap();
        }
    }

    private static String lastSegment(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static Multimap<ApplicationUser, Reason> scaleScores(Multimap<ApplicationUser, SimpleReason> suggestions) {
        if (suggestions.isEmpty()) {
            return HashMultimap.create();
        }
        int max = ((SimpleReason)Collections.max(suggestions.values())).getScore();
        return Multimaps.transformValues(suggestions, input -> {
            int scaledScore = (int)(100.0f * (float)input.getScore() / (float)max);
            return new SimpleReason(input.getShortDescription(), input.getDescription(), scaledScore);
        });
    }

    private static List<Map.Entry<String, Pair<Integer, Integer>>> sortByAbsDelta(Map<String, Pair<Integer, Integer>> pathDeltas) {
        return pathDeltas.entrySet().stream().sorted((a, b) -> Math.max((Integer)((Pair)b.getValue()).left(), Math.abs((Integer)((Pair)b.getValue()).right())) - Math.max((Integer)((Pair)a.getValue()).left(), Math.abs((Integer)((Pair)a.getValue()).right()))).collect(Collectors.toList());
    }

    private Map<ApplicationUser, Integer> getBlame(Repository repository, Repository secondary, String path, String at, Map<String, ApplicationUser> usersByEmail) {
        HashMap<ApplicationUser, Integer> blame = new HashMap<ApplicationUser, Integer>();
        Map blameByEmail = (Map)((GitBlameBuilder)this.builderFactory.builderFor(repository, secondary).blame().incremental().file(path).rev(at).exitHandler((CommandExitHandler)new MissingPathIgnoringExitHandler(this.i18nService, repository))).build((CommandOutputHandler)new BlameAttributionOutputHandler()).call();
        if (blameByEmail == null) {
            return blame;
        }
        for (Map.Entry entry : blameByEmail.entrySet()) {
            ApplicationUser user;
            if (usersByEmail.containsKey(entry.getKey())) {
                user = usersByEmail.get(entry.getKey());
            } else {
                user = this.userResolver.resolve((String)entry.getKey());
                usersByEmail.put((String)entry.getKey(), user);
            }
            if (user == null) continue;
            blame.put(user, (Integer)entry.getValue());
        }
        return blame;
    }

    private DiffSummary getDiffSummary(Commit since, Commit until) {
        DiffSummaryOutputHandler outputHandler = new DiffSummaryOutputHandler();
        ((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.builderFactory.builderFor(since, until).command("diff")).argument("--summary")).argument(since.getId() + ".." + until.getId())).build((CommandOutputHandler)outputHandler).call();
        return outputHandler;
    }

    private List<Map.Entry<String, Pair<Integer, Integer>>> getPathDeltas(Commit since, Commit until) {
        Map deltas = (Map)((GitScmCommandBuilder)((GitScmCommandBuilder)((GitScmCommandBuilder)this.builderFactory.builderFor(since, until).command("diff")).argument("--numstat")).argument(since.getId() + ".." + until.getId())).build((CommandOutputHandler)new DiffNumstatOutputHandler()).call();
        if (deltas == null) {
            return Collections.emptyList();
        }
        return BlameSuggester.sortByAbsDelta(deltas);
    }
}

