/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers.suggester;

import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.server.internal.suggestreviewers.util.IntHolder;
import com.atlassian.bitbucket.server.internal.suggestreviewers.util.StringUtils;
import com.atlassian.bitbucket.server.suggestreviewers.PullRequestDetails;
import com.atlassian.bitbucket.server.suggestreviewers.spi.Reason;
import com.atlassian.bitbucket.server.suggestreviewers.spi.ReviewerSuggester;
import com.atlassian.bitbucket.server.suggestreviewers.spi.SimpleReason;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.google.common.collect.HashMultimap;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ContributorSuggester
implements ReviewerSuggester {
    private static final int MAX_COMMITS = 100;
    private static final int SCORE_PER_COMMIT = 1000;
    private final CommitService commitService;

    public ContributorSuggester(CommitService commitService) {
        this.commitService = commitService;
    }

    @Override
    @Nonnull
    public Map<ApplicationUser, Collection<Reason>> suggestFor(@Nonnull PullRequestDetails pullRequestDetails) {
        Objects.requireNonNull(pullRequestDetails, "pullRequestDetails");
        Commit since = pullRequestDetails.getMergeBase();
        Commit until = pullRequestDetails.getFromCommit();
        if (since == null || until.getRepository() == null) {
            return Collections.emptyMap();
        }
        CommitsBetweenRequest request = new CommitsBetweenRequest.Builder(until.getRepository()).include(until.getId(), new String[0]).exclude(since.getId(), new String[0]).secondaryRepository(until.getRepository()).build();
        final IntHolder commitCounter = new IntHolder();
        final HashMap contributors = new HashMap();
        this.commitService.streamCommitsBetween(request, (CommitCallback)new AbstractCommitCallback(this){

            public boolean onCommit(@Nonnull Commit commit) {
                Person author = commit.getAuthor();
                if (author instanceof ApplicationUser) {
                    ApplicationUser user = (ApplicationUser)author;
                    IntHolder count = (IntHolder)contributors.get(user);
                    if (count == null) {
                        count = new IntHolder();
                        contributors.put(user, count);
                    }
                    count.increment();
                }
                return commitCounter.increment() < 100;
            }
        });
        HashMultimap suggestions = HashMultimap.create();
        for (Map.Entry entry : contributors.entrySet()) {
            int commitCount = ((IntHolder)entry.getValue()).get();
            String description = commitCounter.get() < 100 ? "Authored " + commitCount + " " + StringUtils.pluralize(commitCount, "commit", "commits") + " to be merged." : "Authored some of the commits to be merged.";
            suggestions.put((Object)((ApplicationUser)entry.getKey()), (Object)new SimpleReason(description, commitCount * 1000));
        }
        return suggestions.asMap();
    }
}

