/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git;

import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.LineReaderOutputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.server.internal.suggestreviewers.util.IntHolder;
import com.google.common.collect.Maps;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlameAttributionOutputHandler
extends LineReaderOutputHandler
implements CommandOutputHandler<Map<String, Integer>> {
    private static final Pattern AUTHOR_MAIL = Pattern.compile("^author-mail <(.*)>$");
    private static final Pattern COMMIT = Pattern.compile("([a-f0-9]{40}) [0-9]+ [0-9]+ ([0-9]+)");
    private final Map<String, IntHolder> authorLoc = Maps.newHashMap();
    private final Map<String, String> commit2Author = Maps.newHashMap();
    private String commit;
    private int unappliedLoc = -1;

    public BlameAttributionOutputHandler() {
        super(StandardCharsets.UTF_8);
    }

    @Nullable
    public Map<String, Integer> getOutput() {
        return Maps.transformValues(this.authorLoc, IntHolder.TO_INT::apply);
    }

    protected void processReader(LineReader lineReader) throws IOException {
        String line;
        while ((line = lineReader.readLine()) != null) {
            String author;
            Matcher m;
            if (this.unappliedLoc > 0) {
                m = AUTHOR_MAIL.matcher(line);
                if (!m.matches()) continue;
                author = m.group(1);
                this.getHolder(author).add(this.unappliedLoc);
                this.commit2Author.put(this.commit, author);
                this.unappliedLoc = -1;
                continue;
            }
            m = COMMIT.matcher(line);
            if (!m.matches()) continue;
            this.commit = m.group(1);
            author = this.commit2Author.get(this.commit);
            int loc = Integer.parseInt(m.group(2));
            if (author != null) {
                this.getHolder(author).add(loc);
                continue;
            }
            this.unappliedLoc = loc;
        }
    }

    private IntHolder getHolder(String author) {
        IntHolder holder = this.authorLoc.get(author);
        if (holder == null) {
            holder = new IntHolder();
            this.authorLoc.put(author, holder);
        }
        return holder;
    }
}

