/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git;

import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.LineReaderOutputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffNumstatOutputHandler
extends LineReaderOutputHandler
implements CommandOutputHandler<Map<String, Pair<Integer, Integer>>> {
    private static final Pattern NUMSTAT = Pattern.compile("^(\\d+)\\s+(\\d+)\\s+(.*)$");
    private final Map<String, Pair<Integer, Integer>> pathDeltas = new HashMap<String, Pair<Integer, Integer>>();

    public DiffNumstatOutputHandler() {
        super(StandardCharsets.UTF_8);
    }

    @Nullable
    public Map<String, Pair<Integer, Integer>> getOutput() {
        return this.pathDeltas;
    }

    protected void processReader(LineReader lineReader) throws IOException {
        String line;
        while ((line = lineReader.readLine()) != null) {
            Matcher m = NUMSTAT.matcher(line);
            if (!m.matches()) continue;
            this.pathDeltas.put(m.group(3), (Pair<Integer, Integer>)Pair.pair((Object)Integer.parseInt(m.group(1)), (Object)Integer.parseInt(m.group(2))));
        }
    }
}

