/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git;

import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.LineReaderOutputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.server.internal.suggestreviewers.suggester.git.DiffSummary;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffSummaryOutputHandler
extends LineReaderOutputHandler
implements CommandOutputHandler<Void>,
DiffSummary {
    private static final Pattern SUMMARY = Pattern.compile("^\\s(delete|create)\\smode\\s(\\d{6})\\s(.*)$");
    private final Set<String> createdPaths = new HashSet<String>();
    private final Set<String> deletedPaths = new HashSet<String>();

    public DiffSummaryOutputHandler() {
        super(StandardCharsets.UTF_8);
    }

    @Override
    public Set<String> getCreatedPaths() {
        return this.createdPaths;
    }

    @Override
    public Set<String> getDeletedPaths() {
        return this.deletedPaths;
    }

    @Nullable
    public Void getOutput() {
        return null;
    }

    protected void processReader(LineReader lineReader) throws IOException {
        String line;
        while ((line = lineReader.readLine()) != null) {
            Matcher m = SUMMARY.matcher(line);
            if (!m.matches()) continue;
            String status = m.group(1);
            String path = m.group(3);
            if ("create".matches(status)) {
                this.createdPaths.add(path);
                continue;
            }
            if (!"delete".matches(status)) continue;
            this.deletedPaths.add(path);
        }
    }
}

