/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.suggestreviewers;

import com.atlassian.bitbucket.commit.Commit;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public final class PullRequestDetails {
    private final Commit fromCommit;
    private final String fromRefId;
    private final Commit mergeBase;
    private final Commit toCommit;
    private final String toRefId;

    private PullRequestDetails(Builder builder) {
        this.fromCommit = builder.fromCommit;
        this.toCommit = builder.toCommit;
        this.mergeBase = builder.mergeBase;
        this.fromRefId = builder.fromRefId;
        this.toRefId = builder.toRefId;
    }

    @Nonnull
    public Commit getFromCommit() {
        return this.fromCommit;
    }

    @Nullable
    public String getFromRefId() {
        return this.fromRefId;
    }

    @Nullable
    public Commit getMergeBase() {
        return this.mergeBase;
    }

    @Nonnull
    public Commit getToCommit() {
        return this.toCommit;
    }

    @Nullable
    public String getToRefId() {
        return this.toRefId;
    }

    public static class Builder {
        private Commit fromCommit;
        private String fromRefId;
        private Commit mergeBase;
        private Commit toCommit;
        private String toRefId;

        @Nonnull
        public PullRequestDetails build() {
            return new PullRequestDetails(this);
        }

        @Nonnull
        public Builder fromCommit(@Nonnull Commit fromCommit) {
            this.fromCommit = Objects.requireNonNull(fromCommit, "fromCommit");
            return this;
        }

        @Nonnull
        public Builder fromRefId(@Nullable String fromRefId) {
            this.fromRefId = fromRefId;
            return this;
        }

        @Nonnull
        public Builder mergeBase(@Nullable Commit mergeBase) {
            this.mergeBase = mergeBase;
            return this;
        }

        @Nonnull
        public Builder toCommit(@Nonnull Commit toCommit) {
            this.toCommit = Objects.requireNonNull(toCommit, "toCommit");
            return this;
        }

        @Nonnull
        public Builder toRefId(@Nullable String toRefId) {
            this.toRefId = toRefId;
            return this;
        }
    }
}

