/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.attribute;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AttributeMap
implements Map<String, Object> {
    private final Map<String, Object> delegate;

    AttributeMap(Map<String, Object> delegate) {
        this.delegate = delegate;
    }

    public AttributeMap() {
        this(new HashMap<String, Object>());
    }

    @Nullable
    public <T> T getAs(@Nonnull String key, @Nonnull Class<T> expectedType) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(expectedType, "expectedType");
        return expectedType.cast(this.internalGet(key));
    }

    @Nullable
    public <E, I extends Iterable<E>> I getAs(@Nonnull String key, @Nonnull Class<I> iterableType, @Nonnull Class<E> elementType) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(iterableType, "iterableType");
        Objects.requireNonNull(elementType, "elementType");
        return (I)((Iterable)iterableType.cast(this.get(key)));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeMap that = (AttributeMap)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public Object get(Object key) {
        return this.internalGet(key);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.delegate.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    @Nonnull
    public Collection<Object> values() {
        return this.delegate.values();
    }

    private Object internalGet(@Nonnull Object key) {
        return this.delegate.get(key);
    }
}

