/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.build.status;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.TestResults;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class RepositoryBuildStatusSetRequest {
    private final String buildNumber;
    private final String commitId;
    private final String description;
    private final Long duration;
    private final String key;
    private final Date lastUpdated;
    private final String name;
    private final String parent;
    private final String ref;
    private final Repository repository;
    private final BuildState state;
    private final TestResults testResults;
    private final String url;

    private RepositoryBuildStatusSetRequest(Builder builder) {
        this.buildNumber = builder.buildNumber;
        this.commitId = builder.commitId;
        this.description = builder.description;
        this.duration = builder.duration;
        this.lastUpdated = (Date)ObjectUtils.firstNonNull((Object[])new Date[]{builder.lastUpdated, new Date()});
        this.key = builder.key;
        this.name = builder.name;
        this.parent = builder.parent;
        this.ref = builder.ref;
        this.repository = builder.repository;
        this.state = builder.state;
        this.testResults = builder.testResults;
        this.url = builder.url;
    }

    @Nullable
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Long getDuration() {
        return this.duration;
    }

    @Nonnull
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getParent() {
        return this.parent;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public BuildState getState() {
        return this.state;
    }

    @Nullable
    public TestResults getTestResults() {
        return this.testResults;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final String key;
        private final Repository repository;
        private String buildNumber;
        private String description;
        private Long duration;
        private Date lastUpdated;
        private String name;
        private String parent;
        private String ref;
        private BuildState state;
        private TestResults testResults;
        private String url;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String key) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.commitId = commitId;
            this.key = Builder.requireNonBlank(key, "key");
        }

        @Nonnull
        public RepositoryBuildStatusSetRequest build() {
            Builder.checkNotBlank(this.key, "key");
            Objects.requireNonNull(this.state, "state");
            Builder.checkNotBlank(this.url, "url");
            return new RepositoryBuildStatusSetRequest(this);
        }

        @Nonnull
        public Builder buildNumber(@Nullable String value) {
            this.buildNumber = StringUtils.trimToNull((String)value);
            if (StringUtils.length((CharSequence)this.ref) > 255) {
                throw new IllegalArgumentException("The buildNumber can't be longer than 1024");
            }
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = StringUtils.trimToNull((String)StringUtils.abbreviate((String)value, (int)255));
            return this;
        }

        @Nonnull
        public Builder duration(@Nullable Long value) {
            this.duration = value;
            return this;
        }

        @Nonnull
        public Builder lastUpdated(@Nullable Date value) {
            this.lastUpdated = value;
            return this;
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder parent(@Nullable String value) {
            this.parent = StringUtils.trimToNull((String)value);
            if (StringUtils.length((CharSequence)this.ref) > 1024) {
                throw new IllegalArgumentException("The parent can't be longer than 1024");
            }
            return this;
        }

        @Nonnull
        public Builder ref(@Nullable String value) {
            this.ref = StringUtils.trimToNull((String)value);
            if (StringUtils.length((CharSequence)this.ref) > 1024) {
                throw new IllegalArgumentException("The ref can't be longer than 1024");
            }
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull BuildState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }

        @Nonnull
        public Builder testResults(@Nonnull TestResults testResults) {
            this.testResults = testResults;
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String value) {
            this.url = Builder.checkNotBlank(value, "url");
            return this;
        }
    }
}

